/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.markers.area.Area;
import net.pl3x.map.core.markers.area.Border;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WorldConfig
extends AbstractConfig {
    @AbstractConfig.Key(value="enabled")
    @AbstractConfig.Comment(value="Enables this world to be rendered on the map.")
    public boolean ENABLED = true;
    @AbstractConfig.Key(value="render.renderers")
    @AbstractConfig.Comment(value="Renderers to use. Each renderer will render a different type of map. The value is the icon\nthat the renderer should use in the Web UI. These are any \"*.png\" files under \"web/images/icon/\"\n\nThe built-in renderers include (key):\nvintage_story, basic, biomes, flowermap, inhabited, night, nether_roof, and vanilla\n\nThe built-in icons include (value):\noverworld_basic, overworld_biomes, overworld_night,\nnether_basic, nether_biomes, nether_night, nether_roof,\nthe_end_basic, the_end_biomes, the_end_night,\nflowermap, inhabited, vanilla")
    public Map<String, String> RENDER_RENDERERS = new LinkedHashMap<String, String>(){
        {
            this.put("vintage_story", "overworld_basic");
        }
    };
    @AbstractConfig.Key(value="render.biome-blend")
    @AbstractConfig.Comment(value="Enables blending of biome grass/foliage/water colors similar to\nthe client's biome blending option.\nValues are clamped to 0-7")
    public int RENDER_BIOME_BLEND = 3;
    @AbstractConfig.Key(value="render.skylight")
    @AbstractConfig.Comment(value="World skylight value. This is used for the day/night cycle\nmap (not yet implemented) .Values are clamped to 0-15\nwith 0 being darkest and 15 being full bright.")
    public int RENDER_SKYLIGHT = 15;
    @AbstractConfig.Key(value="render.translucent-fluids")
    @AbstractConfig.Comment(value="Enable translucent fluids.\nThis will make the fluids look fancier and translucent,\nso you can see the blocks below in shallow fluids.")
    public boolean RENDER_TRANSLUCENT_FLUIDS = true;
    @AbstractConfig.Key(value="render.translucent-glass")
    @AbstractConfig.Comment(value="Enable translucent glass.\nThis will make the glass look fancier and translucent,\nso you can see the blocks below.")
    public boolean RENDER_TRANSLUCENT_GLASS = true;
    @AbstractConfig.Key(value="render.heightmap-type")
    @AbstractConfig.Comment(value="Type of heightmap to render.\nNONE has no heightmap drawn.\nEVEN_ODD makes every other Y layer darker, like Dynmap.\nHIGH_CONTRAST same as MODERN, but darker.\nLOW_CONTRAST same as MODERN, but lighter.\nMODERN is a clearer, more detailed view.\nOLD_SCHOOL is the old type from v1.\nVANILLA matches the in-game vanilla maps.\nEVEN_ODD_HIGH_CONTRAST mix of EVEN_ODD and HIGH_CONTRAST.\nEVEN_ODD_LOW_CONTRAST mix of EVEN_ODD and LOW_CONTRAST.\nEVEN_ODD_MODERN mix of EVEN_ODD and MODERN.\nEVEN_ODD_OLD_SCHOOL mix of EVEN_ODD and OLD_SCHOOL.\nEVEN_ODD_VANILLA mix of EVEN_ODD and VANILLA.")
    public String RENDER_HEIGHTMAP_TYPE = "MODERN";
    @AbstractConfig.Key(value="ui.display-name")
    @AbstractConfig.Comment(value="The display name of the world in the world list.\nUse <world> to use the official world name.")
    public String DISPLAY_NAME = "<world>";
    @AbstractConfig.Key(value="ui.order")
    @AbstractConfig.Comment(value="The order of the world in the world list")
    public int ORDER = 0;
    @AbstractConfig.Key(value="ui.attribution")
    @AbstractConfig.Comment(value="Shows the footer attributes")
    public boolean UI_ATTRIBUTION = true;
    @AbstractConfig.Key(value="ui.blockinfo")
    @AbstractConfig.Comment(value="The display position for the blockinfo box")
    public String UI_BLOCKINFO = "bottomleft";
    @AbstractConfig.Key(value="ui.coords")
    @AbstractConfig.Comment(value="The display position for the coordinates box")
    public String UI_COORDS = "bottomcenter";
    @AbstractConfig.Key(value="ui.link")
    @AbstractConfig.Comment(value="The display position for the link box")
    public String UI_LINK = "bottomright";
    @AbstractConfig.Key(value="center.x")
    @AbstractConfig.Comment(value="The x coordinate for the map to load at.\nA value of -1 will default to world spawn.")
    public int CENTER_X = -1;
    @AbstractConfig.Key(value="center.z")
    @AbstractConfig.Comment(value="The z coordinate for the map to load at.\nA value of -1 will default to world spawn.")
    public int CENTER_Z = -1;
    @AbstractConfig.Key(value="zoom.default")
    @AbstractConfig.Comment(value="The default zoom when loading the map in browser.\nNormal sized tiles (1 pixel = 1 block) are\nalways at zoom level 0.")
    public int ZOOM_DEFAULT = 0;
    @AbstractConfig.Key(value="zoom.max-out")
    @AbstractConfig.Comment(value="The maximum zoom out you can do on the map.\nEach additional level requires a new set of tiles\nto be rendered, so don't go too wild here.")
    public int ZOOM_MAX_OUT = 3;
    @AbstractConfig.Key(value="zoom.max-in")
    @AbstractConfig.Comment(value="Extra zoom in layers will stretch the original\ntile images so you can zoom in further without\nthe extra cost of rendering more tiles.")
    public int ZOOM_MAX_IN = 2;
    @AbstractConfig.Key(value="render.visible-areas")
    @AbstractConfig.Comment(value="Visible areas of the world.")
    public List<Area> VISIBLE_AREAS = new ArrayList<Area>();
    private final World world;

    public WorldConfig(World world) {
        this.world = world;
        this.VISIBLE_AREAS.add(new Border(world));
        this.reload();
    }

    public void reload() {
        this.reload(Pl3xMap.api().getMainDir().resolve("config.yml"), WorldConfig.class);
        this.RENDER_BIOME_BLEND = Mathf.clamp(0, 7, this.RENDER_BIOME_BLEND);
        this.RENDER_SKYLIGHT = Mathf.clamp(0, 15, this.RENDER_SKYLIGHT);
    }

    @Override
    protected Object getClassObject() {
        return this;
    }

    @Override
    protected @Nullable Object getValue(String path, @Nullable Object def) {
        if (this.getConfig().get("world-settings.default." + path) == null) {
            this.set("world-settings.default." + path, def);
        }
        return this.get("world-settings." + this.world.getName() + "." + path, this.get("world-settings.default." + path, def));
    }

    @Override
    protected void setComment(String path, @Nullable String comment) {
        this.getConfig().setComment("world-settings.default." + path, comment);
    }

    @Override
    protected @Nullable Object get(String path) {
        if (!path.contains("render.visible-areas")) {
            return super.get(path);
        }
        Object value = this.getConfig().get(path);
        if (!(value instanceof List)) {
            return value;
        }
        List list = (List)value;
        ArrayList<Area> areas = new ArrayList<Area>();
        for (Map map : list) {
            areas.add(Area.deserialize(this.world, map));
        }
        return areas;
    }

    @Override
    protected void set(String path, @Nullable Object value) {
        if (value != null && path.contains("render.visible-areas")) {
            List list = value;
            value = list.stream().map(Area::serialize).toList();
        }
        this.getConfig().set(path, value);
    }
}

