/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import net.pl3x.map.core.event.Event;
import net.pl3x.map.core.event.EventListener;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegisteredHandler {
    private final EventListener listener;
    private final Method method;

    public RegisteredHandler(EventListener listener, Method method) {
        this.listener = listener;
        this.method = method;
    }

    public EventListener getListener() {
        return this.listener;
    }

    public Method getMethod() {
        return this.method;
    }

    public void execute(Event event) throws InvocationTargetException, IllegalAccessException {
        this.getMethod().setAccessible(true);
        this.getMethod().invoke((Object)this.getListener(), event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredHandler other = (RegisteredHandler)o;
        return Objects.equals(this.getListener(), other.getListener()) && Objects.equals(this.getMethod(), other.getMethod());
    }

    public int hashCode() {
        return Objects.hash(this.getListener(), this.getMethod());
    }

    public String toString() {
        return "Handler{listener=" + this.getListener().getClass().getName() + ",method=" + this.getMethod().getName() + "}";
    }
}

