/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.httpd;

import java.io.IOException;
import libs.io.undertow.Handlers;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.sse.ServerSentEventConnection;
import libs.io.undertow.server.handlers.sse.ServerSentEventHandler;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LiveDataHandler {
    private ServerSentEventHandler serverSentEventHandler = Handlers.serverSentEvents();

    public void send(@Nullable String event, @Nullable String data, @Nullable SuccessCallback success, @Nullable FailureCallback failure) {
        if (this.serverSentEventHandler == null) {
            return;
        }
        Callback callback = new Callback(this, success, failure);
        for (ServerSentEventConnection connection : this.serverSentEventHandler.getConnections()) {
            connection.send(data, event, null, callback);
        }
    }

    public void send(@Nullable String event, @Nullable String data, @Nullable SuccessCallback success) {
        this.send(event, data, success, null);
    }

    public void send(@Nullable String event, @Nullable String data) {
        this.send(event, data, null, null);
    }

    public void send(@Nullable String data) {
        this.send(null, data);
    }

    public void closeConnections() {
        for (ServerSentEventConnection connection : this.serverSentEventHandler.getConnections()) {
            connection.shutdown();
        }
    }

    public void handle(HttpServerExchange exchange) throws Exception {
        this.serverSentEventHandler.handleRequest(exchange);
    }

    public ServerSentEventHandler get() {
        return this.serverSentEventHandler;
    }

    private class Callback
    implements ServerSentEventConnection.EventCallback {
        private SuccessCallback success;
        private FailureCallback failure;

        public Callback(@Nullable LiveDataHandler liveDataHandler, @Nullable SuccessCallback success, FailureCallback failure) {
            this.success = success;
            this.failure = failure;
        }

        @Override
        public void done(ServerSentEventConnection connection, @Nullable String data, @Nullable String event, @Nullable String id) {
            if (this.success != null) {
                this.success.apply(connection, data, event, id);
            }
        }

        @Override
        public void failed(ServerSentEventConnection connection, @Nullable String data, @Nullable String event, @Nullable String id, IOException e) {
            if (this.failure != null) {
                this.failure.apply(connection, data, event, id, e);
            }
        }
    }

    @FunctionalInterface
    public static interface SuccessCallback {
        public void apply(ServerSentEventConnection var1, @Nullable String var2, @Nullable String var3, @Nullable String var4);
    }

    @FunctionalInterface
    public static interface FailureCallback {
        public void apply(ServerSentEventConnection var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, IOException var5);
    }
}

