/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.image.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.image.io.Bmp;
import net.pl3x.map.core.image.io.Gif;
import net.pl3x.map.core.image.io.Jpg;
import net.pl3x.map.core.image.io.Png;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.util.FileUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class IO {
    private static final Registry<Type> TYPES = new Registry();

    public static void register() {
        IO.register("bmp", new Bmp());
        IO.register("gif", new Gif());
        IO.register("jpg", new Jpg());
        IO.register("jpeg", IO.get("jpg"));
        IO.register("png", new Png());
    }

    public static void register(String name, Type type) {
        if (TYPES.has(name)) {
            throw new IllegalStateException(String.format("IO type %s already registered", name));
        }
        TYPES.register(name, type);
    }

    public static void unregister() {
        TYPES.unregister();
    }

    public static void unregister(String name) {
        TYPES.unregister(name);
    }

    public static Type get(String format) {
        Type type = TYPES.get(format.toLowerCase(Locale.ROOT));
        if (type == null) {
            throw new IllegalStateException("Unknown or unsupported image format");
        }
        return type;
    }

    public static abstract class Type
    extends Keyed {
        public Type(String key) {
            super(key);
        }

        public BufferedImage createBuffer() {
            return new BufferedImage(512, 512, 2);
        }

        public int color(int argb) {
            return argb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable BufferedImage read(Path path) {
            BufferedImage buffer = null;
            ImageReader reader = null;
            try (ImageInputStream in = ImageIO.createImageInputStream(Files.newInputStream(path, new OpenOption[0]));){
                reader = ImageIO.getImageReadersBySuffix(this.getKey()).next();
                reader.setInput(in, false, true);
                buffer = reader.read(0);
                in.flush();
            }
            catch (IOException e) {
                Logger.warn("Could not read tile image: " + String.valueOf(path), e);
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Path path, BufferedImage buffer) {
            Path tmp = FileUtil.tmp(path);
            ImageWriter writer = null;
            try (ImageOutputStream out = ImageIO.createImageOutputStream(tmp.toFile());){
                writer = ImageIO.getImageWritersBySuffix(this.getKey()).next();
                ImageWriteParam param = writer.getDefaultWriteParam();
                if (param.canWriteCompressed()) {
                    param.setCompressionMode(2);
                    if (param.getCompressionType() == null) {
                        param.setCompressionType(param.getCompressionTypes()[0]);
                    }
                    param.setCompressionQuality((float)Config.WEB_TILE_QUALITY);
                }
                writer.setOutput(out);
                writer.write(null, new IIOImage(buffer, null, null), param);
                out.flush();
            }
            catch (IOException e) {
                Logger.warn("Could not write tile image: " + String.valueOf(tmp), e);
            }
            finally {
                if (writer != null) {
                    writer.dispose();
                }
            }
            try {
                FileUtil.atomicMove(tmp, path);
            }
            catch (IOException e) {
                Logger.warn("Could not write tile image: " + String.valueOf(path), e);
            }
        }
    }
}

