/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CustomLayer
extends WorldLayer {
    public CustomLayer(String key, World world, Supplier<String> labelSupplier) {
        super(key, world, labelSupplier);
    }

    public static void load(World world, Path path) {
        CustomLayer layer;
        try {
            JsonObject obj = (JsonObject)JsonParser.parseReader((Reader)new FileReader(path.toFile()));
            layer = CustomLayer.fromJson(world, obj);
            JsonElement jsonElement = obj.get("markers");
            if (jsonElement instanceof JsonArray) {
                JsonArray markers = (JsonArray)jsonElement;
                markers.forEach(el -> layer.addMarker(Marker.fromJson(el.getAsJsonObject())));
            }
        }
        catch (Throwable t) {
            Logger.severe("Error reading custom marker file: " + String.valueOf(path.toAbsolutePath()), t);
            return;
        }
        world.getLayerRegistry().register(layer.getKey(), layer);
    }

    public static CustomLayer fromJson(World world, JsonObject obj) {
        CustomLayer layer = new CustomLayer(obj.get("key").getAsString(), world, () -> obj.get("label").getAsString());
        JsonElement el = obj.get("updateInterval");
        if (el != null && !(el instanceof JsonNull)) {
            layer.setUpdateInterval(el.getAsInt());
        }
        if ((el = obj.get("showControls")) != null && !(el instanceof JsonNull)) {
            layer.setShowControls(el.getAsBoolean());
        }
        if ((el = obj.get("defaultHidden")) != null && !(el instanceof JsonNull)) {
            layer.setDefaultHidden(el.getAsBoolean());
        }
        if ((el = obj.get("priority")) != null && !(el instanceof JsonNull)) {
            layer.setPriority(el.getAsInt());
        }
        if ((el = obj.get("zIndex")) != null && !(el instanceof JsonNull)) {
            layer.setZIndex(el.getAsInt());
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            layer.setPane(el.getAsString());
        }
        if ((el = obj.get("css")) != null && !(el instanceof JsonNull)) {
            layer.setCss(el.getAsString());
        }
        return layer;
    }
}

