/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Ellipse
extends Marker<Ellipse> {
    private Point center;
    private Vector radius;
    private Double tilt;

    private Ellipse(String key) {
        super("elli", key);
    }

    public Ellipse(String key, double centerX, double centerZ, double radiusX, double radiusZ) {
        this(key, Point.of(centerX, centerZ), Vector.of(radiusX, radiusZ));
    }

    public Ellipse(String key, Point center, double radiusX, double radiusZ) {
        this(key, center, Vector.of(radiusX, radiusZ));
    }

    public Ellipse(String key, double centerX, double centerZ, Vector radius) {
        this(key, Point.of(centerX, centerZ), radius);
    }

    public Ellipse(String key, Point center, Vector radius) {
        this(key);
        this.setCenter(center);
        this.setRadius(radius);
    }

    public Ellipse(String key, double centerX, double centerZ, double radiusX, double radiusZ, double tilt) {
        this(key, Point.of(centerX, centerZ), Vector.of(radiusX, radiusZ), tilt);
    }

    public Ellipse(String key, Point center, double radiusX, double radiusZ, double tilt) {
        this(key, center, Vector.of(radiusX, radiusZ), tilt);
    }

    public Ellipse(String key, double centerX, double centerZ, Vector radius, double tilt) {
        this(key, Point.of(centerX, centerZ), radius, tilt);
    }

    public Ellipse(String key, Point center, Vector radius, double tilt) {
        this(key);
        this.setCenter(center);
        this.setRadius(radius);
        this.setTilt(tilt);
    }

    public static Ellipse of(String key, double centerX, double centerZ, double radiusX, double radiusZ) {
        return new Ellipse(key, centerX, centerZ, radiusX, radiusZ);
    }

    public static Ellipse of(String key, Point center, double radiusX, double radiusZ) {
        return new Ellipse(key, center, radiusX, radiusZ);
    }

    public static Ellipse of(String key, double centerX, double centerZ, Vector radius) {
        return new Ellipse(key, centerX, centerZ, radius);
    }

    public static Ellipse of(String key, Point center, Vector radius) {
        return new Ellipse(key, center, radius);
    }

    public static Ellipse of(String key, double centerX, double centerZ, double radiusX, double radiusZ, double tilt) {
        return new Ellipse(key, centerX, centerZ, radiusX, radiusZ, tilt);
    }

    public static Ellipse of(String key, Point center, double radiusX, double radiusZ, double tilt) {
        return new Ellipse(key, center, radiusX, radiusZ, tilt);
    }

    public static Ellipse of(String key, double centerX, double centerZ, Vector radius, double tilt) {
        return new Ellipse(key, centerX, centerZ, radius, tilt);
    }

    public static Ellipse of(String key, Point center, Vector radius, double tilt) {
        return new Ellipse(key, center, radius, tilt);
    }

    public Point getCenter() {
        return this.center;
    }

    public Ellipse setCenter(Point center) {
        this.center = Preconditions.checkNotNull(center, "Ellipse center is null");
        return this;
    }

    public Vector getRadius() {
        return this.radius;
    }

    public Ellipse setRadius(Vector radius) {
        this.radius = Preconditions.checkNotNull(radius, "Ellipse radius is null");
        return this;
    }

    public @Nullable Double getTilt() {
        return this.tilt;
    }

    public Ellipse setTilt(@Nullable Double tilt) {
        this.tilt = tilt;
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("center", this.getCenter());
        wrapper.addProperty("radius", this.getRadius());
        wrapper.addProperty("tilt", this.getTilt());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Ellipse fromJson(JsonObject obj) {
        Ellipse ellipse = Ellipse.of(obj.get("key").getAsString(), Point.fromJson((JsonObject)obj.get("center")), Vector.fromJson((JsonObject)obj.get("radius")));
        JsonElement el = obj.get("tilt");
        if (el != null && !(el instanceof JsonNull)) {
            ellipse.setTilt(el.getAsDouble());
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            ellipse.setPane(el.getAsString());
        }
        return ellipse;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Ellipse other = (Ellipse)o;
        return this.getKey().equals(other.getKey()) && Objects.equals(this.getCenter(), other.getCenter()) && Objects.equals(this.getRadius(), other.getRadius()) && Objects.equals(this.getTilt(), other.getTilt()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getCenter(), this.getRadius(), this.getTilt(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Ellipse{key=" + this.getKey() + ",center=" + String.valueOf(this.getCenter()) + ",radius=" + String.valueOf(this.getRadius()) + ",tile=" + this.getTilt() + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

