/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Icon
extends Marker<Icon> {
    private Point point;
    private String image;
    private String retina;
    private Vector size;
    private Vector anchor;
    private Double rotationAngle;
    private String rotationOrigin;
    private String shadow;
    private String shadowRetina;
    private Vector shadowSize;
    private Vector shadowAnchor;

    private Icon(String key) {
        super("icon", key);
    }

    public Icon(String key, double x, double z, String image) {
        this(key);
        this.setPoint(Point.of(x, z));
        this.setImage(image);
    }

    public Icon(String key, Point point, String image) {
        this(key);
        this.setPoint(point);
        this.setImage(image);
    }

    public Icon(String key, double x, double z, String image, double size) {
        this(key);
        this.setPoint(Point.of(x, z));
        this.setImage(image);
        this.setSize(Vector.of(size, size));
    }

    public Icon(String key, double x, double z, String image, double width, double height) {
        this(key);
        this.setPoint(Point.of(x, z));
        this.setImage(image);
        this.setSize(Vector.of(width, height));
    }

    public Icon(String key, Point point, String image, double size) {
        this(key);
        this.setPoint(point);
        this.setImage(image);
        this.setSize(Vector.of(size, size));
    }

    public Icon(String key, Point point, String image, double width, double height) {
        this(key);
        this.setPoint(point);
        this.setImage(image);
        this.setSize(Vector.of(width, height));
    }

    public Icon(String key, Point point, String image, @Nullable Vector size) {
        this(key);
        this.setPoint(point);
        this.setImage(image);
        this.setSize(size);
    }

    public static Icon of(String key, double x, double z, String image) {
        return new Icon(key, x, z, image);
    }

    public static Icon of(String key, Point point, String image) {
        return new Icon(key, point, image);
    }

    public static Icon of(String key, double x, double z, String image, double size) {
        return new Icon(key, x, z, image, size);
    }

    public static Icon of(String key, double x, double z, String image, double width, double height) {
        return new Icon(key, x, z, image, width, height);
    }

    public static Icon of(String key, Point point, String image, double size) {
        return new Icon(key, point, image, size);
    }

    public static Icon of(String key, Point point, String image, double width, double height) {
        return new Icon(key, point, image, width, height);
    }

    public static Icon of(String key, Point point, String image, @Nullable Vector size) {
        return new Icon(key, point, image, size);
    }

    public Point getPoint() {
        return this.point;
    }

    public Icon setPoint(Point point) {
        this.point = Preconditions.checkNotNull(point, "Icon point is null");
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public Icon setImage(String image) {
        Preconditions.checkNotNull(image, "Icon key is null");
        Preconditions.checkNotNull((IconImage)Pl3xMap.api().getIconRegistry().get(image), String.format("Icon not in registry (%s)", image));
        this.image = image;
        return this;
    }

    public @Nullable String getRetina() {
        return this.retina;
    }

    public Icon setRetina(@Nullable String retina) {
        Preconditions.checkArgument(retina == null || Pl3xMap.api().getIconRegistry().has(retina), String.format("Icon not in registry (%s)", retina));
        this.retina = retina;
        return this;
    }

    public @Nullable Vector getSize() {
        return this.size;
    }

    public Icon setSize(@Nullable Vector size) {
        this.size = size;
        return this;
    }

    public @Nullable Vector getAnchor() {
        return this.anchor;
    }

    public Icon setAnchor(@Nullable Vector anchor) {
        this.anchor = anchor;
        return this;
    }

    public @Nullable Double getRotationAngle() {
        return this.rotationAngle;
    }

    public Icon setRotationAngle(@Nullable Double rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    public @Nullable String getRotationOrigin() {
        return this.rotationOrigin;
    }

    public Icon setRotationOrigin(@Nullable String rotationOrigin) {
        this.rotationOrigin = rotationOrigin;
        return this;
    }

    public @Nullable String getShadow() {
        return this.shadow;
    }

    public Icon setShadow(@Nullable String shadow) {
        Preconditions.checkArgument(shadow == null || Pl3xMap.api().getIconRegistry().has(shadow), String.format("Icon not in registry (%s)", shadow));
        this.shadow = shadow;
        return this;
    }

    public @Nullable String getShadowRetina() {
        return this.shadowRetina;
    }

    public Icon setShadowRetina(@Nullable String shadowRetina) {
        Preconditions.checkArgument(shadowRetina == null || Pl3xMap.api().getIconRegistry().has(shadowRetina), String.format("Icon not in registry (%s)", shadowRetina));
        this.shadowRetina = shadowRetina;
        return this;
    }

    public @Nullable Vector getShadowSize() {
        return this.shadowSize;
    }

    public Icon setShadowSize(@Nullable Vector shadowSize) {
        this.shadowSize = shadowSize;
        return this;
    }

    public @Nullable Vector getShadowAnchor() {
        return this.shadowAnchor;
    }

    public Icon setShadowAnchor(@Nullable Vector shadowAnchor) {
        this.shadowAnchor = shadowAnchor;
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("point", this.getPoint());
        wrapper.addProperty("image", this.getImage());
        wrapper.addProperty("retina", this.getRetina());
        wrapper.addProperty("size", this.getSize());
        wrapper.addProperty("anchor", this.getAnchor());
        wrapper.addProperty("shadow", this.getShadow());
        wrapper.addProperty("shadowRetina", this.getShadowRetina());
        wrapper.addProperty("shadowSize", this.getShadowSize());
        wrapper.addProperty("shadowAnchor", this.getShadowAnchor());
        wrapper.addProperty("rotationAngle", this.getRotationAngle());
        wrapper.addProperty("rotationOrigin", this.getRotationOrigin());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Icon fromJson(JsonObject obj) {
        Icon icon = Icon.of(obj.get("key").getAsString(), Point.fromJson((JsonObject)obj.get("point")), Objects.requireNonNull(Icon.registerIconImage("image", obj)));
        icon.setRetina(Icon.registerIconImage("retina", obj));
        JsonElement el = obj.get("size");
        if (el != null && !(el instanceof JsonNull)) {
            icon.setSize(Vector.fromJson((JsonObject)obj.get("size")));
        }
        if ((el = obj.get("anchor")) != null && !(el instanceof JsonNull)) {
            icon.setAnchor(Vector.fromJson((JsonObject)obj.get("anchor")));
        }
        icon.setShadow(Icon.registerIconImage("shadow", obj));
        icon.setShadowRetina(Icon.registerIconImage("shadowRetina", obj));
        el = obj.get("shadowSize");
        if (el != null && !(el instanceof JsonNull)) {
            icon.setShadowSize(Vector.fromJson((JsonObject)obj.get("shadowSize")));
        }
        if ((el = obj.get("shadowAnchor")) != null && !(el instanceof JsonNull)) {
            icon.setShadowAnchor(Vector.fromJson((JsonObject)obj.get("shadowAnchor")));
        }
        if ((el = obj.get("rotationAngle")) != null && !(el instanceof JsonNull)) {
            icon.setRotationAngle(el.getAsDouble());
        }
        if ((el = obj.get("rotationOrigin")) != null && !(el instanceof JsonNull)) {
            icon.setRotationOrigin(el.getAsString());
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            icon.setPane(el.getAsString());
        }
        return icon;
    }

    private static @Nullable String registerIconImage(String key, JsonObject obj) {
        String image = null;
        JsonElement el = obj.get(key);
        if (el != null && !(el instanceof JsonNull)) {
            try {
                image = el.getAsString();
                Path path = FileUtil.getWebDir().resolve("images/icon/" + image + ".png");
                IconImage icon = new IconImage(image, ImageIO.read(path.toFile()), "png");
                Pl3xMap.api().getIconRegistry().register(icon);
            }
            catch (IOException e) {
                Object[] objectArray = new Object[1];
                image = el.getAsString();
                objectArray[0] = "images/icon/" + image + ".png";
                throw new RuntimeException("Can't read file from path: %s".formatted(objectArray), e);
            }
        }
        return image;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Icon other = (Icon)o;
        return this.getKey().equals(other.getKey()) && this.getPoint().equals(other.getPoint()) && this.isImageEquals(other) && this.isPositionEquals(other) && this.isShadowEquals(other) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    private boolean isImageEquals(@Nullable Icon other) {
        return this.getImage().equals(other.getImage()) && Objects.equals(this.getRetina(), other.getRetina()) && Objects.equals(this.getSize(), other.getSize());
    }

    private boolean isPositionEquals(@Nullable Icon other) {
        return Objects.equals(this.getAnchor(), other.getAnchor()) && Objects.equals(this.getRotationAngle(), other.getRotationAngle()) && Objects.equals(this.getRotationOrigin(), other.getRotationOrigin());
    }

    private boolean isShadowEquals(@Nullable Icon other) {
        return Objects.equals(this.getShadow(), other.getShadow()) && Objects.equals(this.getShadowRetina(), other.getShadowRetina()) && Objects.equals(this.getShadowSize(), other.getShadowSize()) && Objects.equals(this.getShadowAnchor(), other.getShadowAnchor());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getPoint(), this.getImage(), this.getRetina(), this.getSize(), this.getAnchor(), this.getRotationAngle(), this.getRotationOrigin(), this.getShadow(), this.getShadowRetina(), this.getShadowSize(), this.getShadowAnchor(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Icon{key=" + this.getKey() + ",point=" + String.valueOf(this.getPoint()) + ",image=" + this.getImage() + ",retina=" + this.getRetina() + ",size=" + String.valueOf(this.getSize()) + ",anchor=" + String.valueOf(this.getAnchor()) + ",rotationAngle=" + this.getRotationAngle() + ",rotationOrigin=" + this.getRotationOrigin() + ",shadow=" + this.getShadow() + ",shadowRetina=" + this.getShadowRetina() + ",shadowSize=" + String.valueOf(this.getShadowSize()) + ",shadowAnchor=" + String.valueOf(this.getShadowAnchor()) + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

