/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.List;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.JsonSerializable;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.marker.Circle;
import net.pl3x.map.core.markers.marker.Ellipse;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.MultiPolygon;
import net.pl3x.map.core.markers.marker.MultiPolyline;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Marker<T extends Marker<T>>
extends Keyed
implements JsonSerializable {
    private final String type;
    private String pane;
    private Options options;

    public Marker(String type, String key) {
        super(key);
        this.type = Preconditions.checkNotNull(type, "Marker type is null");
    }

    public static Circle circle(String key, double centerX, double centerZ, double radius) {
        return Circle.of(key, centerX, centerZ, radius);
    }

    public static Circle circle(String key, Point center, double radius) {
        return Circle.of(key, center, radius);
    }

    public static Ellipse ellipse(String key, double centerX, double centerZ, double radiusX, double radiusZ) {
        return Ellipse.of(key, centerX, centerZ, radiusX, radiusZ);
    }

    public static Ellipse ellipse(String key, Point center, double radiusX, double radiusZ) {
        return Ellipse.of(key, center, radiusX, radiusZ);
    }

    public static Ellipse ellipse(String key, double centerX, double centerZ, Vector radius) {
        return Ellipse.of(key, centerX, centerZ, radius);
    }

    public static Ellipse ellipse(String key, Point center, Vector radius) {
        return Ellipse.of(key, center, radius);
    }

    public static Ellipse ellipse(String key, double centerX, double centerZ, double radiusX, double radiusZ, double tilt) {
        return Ellipse.of(key, centerX, centerZ, radiusX, radiusZ, tilt);
    }

    public static Ellipse ellipse(String key, Point center, double radiusX, double radiusZ, double tilt) {
        return Ellipse.of(key, center, radiusX, radiusZ, tilt);
    }

    public static Ellipse ellipse(String key, double centerX, double centerZ, Vector radius, double tilt) {
        return Ellipse.of(key, centerX, centerZ, radius, tilt);
    }

    public static Ellipse ellipse(String key, Point center, Vector radius, double tilt) {
        return Ellipse.of(key, center, radius, tilt);
    }

    public static Icon icon(String key, double x, double z, String image) {
        return Icon.of(key, x, z, image);
    }

    public static Icon icon(String key, Point point, String image) {
        return Icon.of(key, point, image);
    }

    public static Icon icon(String key, double x, double z, String image, double size) {
        return Icon.of(key, x, z, image, size, size);
    }

    public static Icon icon(String key, double x, double z, String image, double width, double height) {
        return Icon.of(key, x, z, image, width, height);
    }

    public static Icon icon(String key, Point point, String image, double size) {
        return Icon.of(key, point, image, size, size);
    }

    public static Icon icon(String key, Point point, String image, double width, double height) {
        return Icon.of(key, point, image, width, height);
    }

    public static Icon icon(String key, Point point, String image, @Nullable Vector size) {
        return Icon.of(key, point, image, size);
    }

    public static MultiPolygon multiPolygon(String key, Polygon polygon) {
        return MultiPolygon.of(key, polygon);
    }

    public static MultiPolygon multiPolygon(String key, Polygon ... polygons) {
        return MultiPolygon.of(key, polygons);
    }

    public static MultiPolygon multiPolygon(String key, List<Polygon> polygons) {
        return MultiPolygon.of(key, polygons);
    }

    public static MultiPolyline multiPolyline(String key, Polyline polyline) {
        return MultiPolyline.of(key, polyline);
    }

    public static MultiPolyline multiPolyline(String key, Polyline ... polylines) {
        return MultiPolyline.of(key, polylines);
    }

    public static MultiPolyline multiPolyline(String key, List<Polyline> polylines) {
        return MultiPolyline.of(key, polylines);
    }

    public static Polygon polygon(String key, Polyline polyline) {
        return Polygon.of(key, polyline);
    }

    public static Polygon polygon(String key, Polyline ... polylines) {
        return Polygon.of(key, polylines);
    }

    public static Polygon polygon(String key, List<Polyline> polylines) {
        return Polygon.of(key, polylines);
    }

    public static Polyline polyline(String key, Point point) {
        return Polyline.of(key, point);
    }

    public static Polyline polyline(String key, Point ... points) {
        return Polyline.of(key, points);
    }

    public static Polyline polyline(String key, List<Point> points) {
        return Polyline.of(key, points);
    }

    public static Rectangle rectangle(String key, double x1, double z1, double x2, double z2) {
        return Rectangle.of(key, x1, z1, x2, z2);
    }

    public static Rectangle rectangle(String key, Point point1, Point point2) {
        return Rectangle.of(key, point1, point2);
    }

    public String getType() {
        return this.type;
    }

    public @Nullable String getPane() {
        return this.pane;
    }

    public T setPane(@Nullable String pane) {
        this.pane = pane;
        return (T)this;
    }

    public @Nullable Options getOptions() {
        return this.options;
    }

    public T setOptions(@Nullable Options options) {
        this.options = options;
        return (T)this;
    }

    public T setOptions(@Nullable Options.Builder builder) {
        return this.setOptions(builder == null ? null : builder.build());
    }

    public static Marker<?> fromJson(JsonObject obj) {
        String type = obj.get("type").getAsString();
        JsonObject data = obj.get("data").getAsJsonObject();
        Marker marker = switch (type) {
            case "circ" -> Circle.fromJson(data);
            case "elli" -> Ellipse.fromJson(data);
            case "icon" -> Icon.fromJson(data);
            case "multipoly" -> MultiPolygon.fromJson(data);
            case "multiline" -> MultiPolyline.fromJson(data);
            case "poly" -> Polygon.fromJson(data);
            case "line" -> Polyline.fromJson(data);
            case "rect" -> Rectangle.fromJson(data);
            default -> throw new IllegalStateException("Marker type not found: " + type);
        };
        JsonElement el = obj.get("options");
        if (el != null && !(el instanceof JsonNull)) {
            marker.setOptions(Options.fromJson((JsonObject)el));
        }
        return marker;
    }
}

