/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Polygon
extends Marker<Polygon> {
    private final List<Polyline> polylines = new ArrayList<Polyline>();

    private Polygon(String key) {
        super("poly", key);
    }

    public Polygon(String key, Polyline polyline) {
        this(key);
        this.addPolyline(polyline);
    }

    public Polygon(String key, Polyline ... polylines) {
        this(key);
        this.addPolyline(polylines);
    }

    public Polygon(String key, Collection<Polyline> polylines) {
        this(key);
        this.addPolyline(polylines);
    }

    public static Polygon of(String key, Polyline polyline) {
        return new Polygon(key, polyline);
    }

    public static Polygon of(String key, Polyline ... polylines) {
        return new Polygon(key, polylines);
    }

    public static Polygon of(String key, Collection<Polyline> polylines) {
        return new Polygon(key, polylines);
    }

    public List<Polyline> getPolylines() {
        return this.polylines;
    }

    public Polygon clearPolylines() {
        this.polylines.clear();
        return this;
    }

    public Polygon addPolyline(Polyline polyline) {
        Preconditions.checkNotNull(polyline, "Polygon polyline is null");
        this.polylines.add(polyline);
        return this;
    }

    public Polygon addPolyline(Polyline ... polylines) {
        Preconditions.checkNotNull(polylines, "Polygon polylines is null");
        for (Polyline polyline : polylines) {
            this.addPolyline(polyline);
        }
        return this;
    }

    public Polygon addPolyline(Collection<Polyline> polylines) {
        Preconditions.checkNotNull(polylines, "Polygon polylines is null");
        this.polylines.addAll(polylines);
        return this;
    }

    public Polygon removeLine(Polyline polyline) {
        Preconditions.checkNotNull(polyline, "Polygon polyline is null");
        this.polylines.remove(polyline);
        return this;
    }

    public Polygon removeLine(Polyline ... polylines) {
        Preconditions.checkNotNull(polylines, "Polygon polylines is null");
        for (Polyline polyline : polylines) {
            this.removeLine(polyline);
        }
        return this;
    }

    public Polygon removeLine(Collection<Polyline> polylines) {
        Preconditions.checkNotNull(polylines, "Polygon polylines is null");
        this.polylines.removeAll(polylines);
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("polylines", this.getPolylines());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Polygon fromJson(JsonObject obj) {
        Polygon polygon = Polygon.of(obj.get("key").getAsString(), new Polyline[0]);
        JsonElement el = obj.get("polylines");
        if (el != null && !(el instanceof JsonNull)) {
            JsonArray arr = el.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                polygon.addPolyline(Polyline.fromJson((JsonObject)arr.get(i)));
            }
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            polygon.setPane(el.getAsString());
        }
        return polygon;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Polygon other = (Polygon)o;
        return this.getKey().equals(other.getKey()) && Objects.equals(this.getPolylines(), other.getPolylines()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getPolylines(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Polygon{key=" + this.getKey() + ",polylines=" + String.valueOf(this.getPolylines()) + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

