/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.metrics;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import libs.org.simpleyaml.configuration.file.YamlConfiguration;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.util.FileUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Metrics {
    private final Pl3xMap pl3xmap;
    private final MetricsBase metricsBase;

    public Metrics(Pl3xMap pl3xmap) throws IOException {
        this.pl3xmap = pl3xmap;
        Path bStatsFolder = this.pl3xmap.getMainDir().resolve("../bStats");
        File configFile = FileUtil.mkDirs(bStatsFolder.resolve("config.yml")).toFile();
        YamlConfiguration config = YamlConfiguration.loadConfiguration(configFile);
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", true);
            config.addDefault("serverUuid", UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", false);
            config.addDefault("logSentData", false);
            config.addDefault("logResponseStatusText", false);
            config.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
            try {
                config.save(configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean enabled = config.getBoolean("enabled", true);
        String serverUUID = config.getString("serverUuid");
        boolean logErrors = config.getBoolean("logFailedRequests", false);
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        this.metricsBase = new MetricsBase("bukkit", serverUUID, enabled, this::appendPlatformData, this::appendServiceData, submitDataTask -> Pl3xMap.api().getScheduler().addTask(0, false, (Runnable)submitDataTask), this.pl3xmap::isEnabled, Logger::warn, Logger::info, logErrors, logSentData, logResponseStatusText);
        this.addCustomChart(new SimplePie("unfiltered_server_software", this.pl3xmap::getPlatform));
        this.addCustomChart(new SimplePie("language_used", () -> Config.LANGUAGE_FILE.replace("lang-", "").replace(".yml", "")));
        this.addCustomChart(new SimplePie("internal_web_server", () -> Config.HTTPD_ENABLED ? "true" : "false"));
        this.addCustomChart(new AdvancedPie("renderers_used", () -> {
            HashMap map = new HashMap();
            this.pl3xmap.getWorldRegistry().forEach(world -> world.getRenderers().forEach((id, builder) -> {
                int count = map.getOrDefault(builder.getName(), 0);
                map.put(builder.getName(), count + 1);
            }));
            return map;
        }));
        this.addCustomChart(new DrilldownPie("plugin_version", () -> {
            String[] version = this.pl3xmap.getVersion().split("-");
            return Map.of(version[0], Map.of(version[1], 1));
        }));
    }

    public void shutdown() {
        this.metricsBase.shutdown();
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", this.pl3xmap.getPlayerRegistry().size());
        builder.appendField("onlineMode", this.pl3xmap.getOnlineMode() ? 1 : 0);
        builder.appendField("bukkitVersion", this.pl3xmap.getServerVersion());
        builder.appendField("bukkitName", this.pl3xmap.getPlatform());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder builder) {
        builder.appendField("pluginVersion", this.pl3xmap.getVersion());
    }

    public static class MetricsBase {
        public static final String METRICS_VERSION = "3.0.2";
        private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";
        private final ScheduledExecutorService scheduler;
        private final String platform;
        private final String serverUuid;
        private final Consumer<JsonObjectBuilder> appendPlatformDataConsumer;
        private final Consumer<JsonObjectBuilder> appendServiceDataConsumer;
        private final Consumer<Runnable> submitTaskConsumer;
        private final Supplier<Boolean> checkServiceEnabledSupplier;
        private final BiConsumer<String, Throwable> errorLogger;
        private final Consumer<String> infoLogger;
        private final boolean logErrors;
        private final boolean logSentData;
        private final boolean logResponseStatusText;
        private final Set<CustomChart> customCharts = new HashSet<CustomChart>();
        private final boolean enabled;

        public MetricsBase(String platform, String serverUuid, boolean enabled, Consumer<JsonObjectBuilder> appendPlatformDataConsumer, Consumer<JsonObjectBuilder> appendServiceDataConsumer, Consumer<Runnable> submitTaskConsumer, Supplier<Boolean> checkServiceEnabledSupplier, BiConsumer<String, Throwable> errorLogger, Consumer<String> infoLogger, boolean logErrors, boolean logSentData, boolean logResponseStatusText) {
            ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, task -> new Thread(task, "bStats-Metrics"));
            scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler = scheduler;
            this.platform = platform;
            this.serverUuid = serverUuid;
            this.enabled = enabled;
            this.appendPlatformDataConsumer = appendPlatformDataConsumer;
            this.appendServiceDataConsumer = appendServiceDataConsumer;
            this.submitTaskConsumer = submitTaskConsumer;
            this.checkServiceEnabledSupplier = checkServiceEnabledSupplier;
            this.errorLogger = errorLogger;
            this.infoLogger = infoLogger;
            this.logErrors = logErrors;
            this.logSentData = logSentData;
            this.logResponseStatusText = logResponseStatusText;
            if (enabled) {
                this.startSubmitting();
            }
        }

        public void addCustomChart(CustomChart chart) {
            this.customCharts.add(chart);
        }

        public void shutdown() {
            this.scheduler.shutdown();
        }

        private void startSubmitting() {
            Runnable submitTask = () -> {
                if (!this.enabled || !this.checkServiceEnabledSupplier.get().booleanValue()) {
                    this.scheduler.shutdown();
                    return;
                }
                if (this.submitTaskConsumer != null) {
                    this.submitTaskConsumer.accept(this::submitData);
                } else {
                    this.submitData();
                }
            };
            long initialDelay = (long)(60000.0 * (3.0 + Math.random() * 3.0));
            long secondDelay = (long)(60000.0 * (Math.random() * 30.0));
            this.scheduler.schedule(submitTask, initialDelay, TimeUnit.MILLISECONDS);
            this.scheduler.scheduleAtFixedRate(submitTask, initialDelay + secondDelay, 1800000L, TimeUnit.MILLISECONDS);
        }

        private void submitData() {
            JsonObjectBuilder builder = new JsonObjectBuilder();
            this.appendPlatformDataConsumer.accept(builder);
            JsonObjectBuilder.JsonObject[] chartData = (JsonObjectBuilder.JsonObject[])this.customCharts.stream().map(customChart -> customChart.getRequestJsonObject(this.errorLogger, this.logErrors)).filter(Objects::nonNull).toArray(JsonObjectBuilder.JsonObject[]::new);
            JsonObjectBuilder serviceJsonBuilder = new JsonObjectBuilder().appendField("id", 10133).appendField("customCharts", chartData);
            this.appendServiceDataConsumer.accept(serviceJsonBuilder);
            builder.appendField("service", serviceJsonBuilder.build());
            builder.appendField("serverUUID", this.serverUuid);
            builder.appendField("metricsVersion", METRICS_VERSION);
            JsonObjectBuilder.JsonObject data = builder.build();
            this.scheduler.execute(() -> {
                block2: {
                    try {
                        this.sendData(data);
                    }
                    catch (Exception e) {
                        if (!this.logErrors) break block2;
                        this.errorLogger.accept("Could not submit bStats metrics data", e);
                    }
                }
            });
        }

        private void sendData(JsonObjectBuilder.JsonObject data) throws Exception {
            if (this.logSentData) {
                this.infoLogger.accept("Sent bStats metrics data: " + String.valueOf(data));
            }
            String url = String.format(REPORT_URL, this.platform);
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            byte[] compressedData = MetricsBase.compress(data.toString());
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Connection", "close");
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Metrics-Service/1");
            connection.setDoOutput(true);
            try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                outputStream.write(compressedData);
            }
            StringBuilder builder = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    builder.append(line);
                }
            }
            if (this.logResponseStatusText) {
                this.infoLogger.accept("Sent data to bStats and received response: " + String.valueOf(builder));
            }
        }

        private static byte[] compress(@Nullable String str) throws IOException {
            if (str == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                gzip.write(str.getBytes(StandardCharsets.UTF_8));
            }
            return outputStream.toByteArray();
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<@Nullable String> callable;

        public SimplePie(String chartId, Callable<@Nullable String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected @Nullable JsonObjectBuilder.JsonObject getChartData() throws Exception {
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            return new JsonObjectBuilder().appendField("value", value).build();
        }
    }

    public static abstract class CustomChart {
        private final String chartId;

        protected CustomChart(@Nullable String chartId) {
            if (chartId == null) {
                throw new IllegalArgumentException("chartId must not be null");
            }
            this.chartId = chartId;
        }

        public @Nullable JsonObjectBuilder.JsonObject getRequestJsonObject(BiConsumer<String, Throwable> errorLogger, boolean logErrors) {
            JsonObjectBuilder builder = new JsonObjectBuilder();
            builder.appendField("chartId", this.chartId);
            try {
                JsonObjectBuilder.JsonObject data = this.getChartData();
                if (data == null) {
                    return null;
                }
                builder.appendField("data", data);
            }
            catch (Throwable t) {
                if (logErrors) {
                    errorLogger.accept("Failed to get data for custom chart with id " + this.chartId, t);
                }
                return null;
            }
            return builder.build();
        }

        protected abstract @Nullable JsonObjectBuilder.JsonObject getChartData() throws Exception;
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<@Nullable Map<String, Integer>> callable;

        public AdvancedPie(String chartId, Callable<@Nullable Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected @Nullable JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                valuesBuilder.appendField(entry.getKey(), entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<@Nullable Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String chartId, Callable<@Nullable Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        public JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
                JsonObjectBuilder valueBuilder = new JsonObjectBuilder();
                boolean allSkipped = true;
                for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                    valueBuilder.appendField(valueEntry.getKey(), valueEntry.getValue());
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                valuesBuilder.appendField(entryValues.getKey(), valueBuilder.build());
            }
            if (reallyAllSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    public static class JsonObjectBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean hasAtLeastOneField = false;

        public JsonObjectBuilder() {
            this.builder.append("{");
        }

        public JsonObjectBuilder appendField(String key, @Nullable String value) {
            if (value == null) {
                throw new IllegalArgumentException("JSON value must not be null");
            }
            this.appendFieldUnescaped(key, "\"" + JsonObjectBuilder.escape(value) + "\"");
            return this;
        }

        public JsonObjectBuilder appendField(String key, int value) {
            this.appendFieldUnescaped(key, String.valueOf(value));
            return this;
        }

        public JsonObjectBuilder appendField(String key, @Nullable JsonObject object) {
            if (object == null) {
                throw new IllegalArgumentException("JSON object must not be null");
            }
            this.appendFieldUnescaped(key, object.toString());
            return this;
        }

        public JsonObjectBuilder appendField(String key, JsonObject[] values) {
            if (values == null) {
                throw new IllegalArgumentException("JSON values must not be null");
            }
            String escapedValues = Arrays.stream(values).map(JsonObject::toString).collect(Collectors.joining(","));
            this.appendFieldUnescaped(key, "[" + escapedValues + "]");
            return this;
        }

        private void appendFieldUnescaped(@Nullable String key, @Nullable String escapedValue) {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            if (key == null) {
                throw new IllegalArgumentException("JSON key must not be null");
            }
            if (this.hasAtLeastOneField) {
                this.builder.append(",");
            }
            this.builder.append("\"").append(JsonObjectBuilder.escape(key)).append("\":").append(escapedValue);
            this.hasAtLeastOneField = true;
        }

        public JsonObject build() {
            if (this.builder == null) {
                throw new IllegalStateException("JSON has already been built");
            }
            JsonObject object = new JsonObject(this.builder.append("}").toString());
            this.builder = null;
            return object;
        }

        private static String escape(String value) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    builder.append("\\\"");
                    continue;
                }
                if (c == '\\') {
                    builder.append("\\\\");
                    continue;
                }
                if (c <= '\u000f') {
                    builder.append("\\u000").append(Integer.toHexString(c));
                    continue;
                }
                if (c <= '\u001f') {
                    builder.append("\\u00").append(Integer.toHexString(c));
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }

        public static class JsonObject {
            private final String value;

            private JsonObject(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }
        }
    }
}

