/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.player;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.FileUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerTexture
extends Thread {
    private static final Path SKINS_2D_DIR = FileUtil.getWebDir().resolve("images/skins/2D");
    private static final Path SKINS_3D_DIR = FileUtil.getWebDir().resolve("images/skins/3D");
    private static final URL STEVE_SKIN;
    private final UUID uuid;
    private final URL url;

    public PlayerTexture(Player player) {
        this.uuid = player.getUUID();
        URL url = player.getSkin();
        if (url == null) {
            url = STEVE_SKIN;
        }
        this.url = url;
    }

    @Override
    public void run() {
        if (this.url == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.url.openStream();
        }
        catch (IOException e) {
            Logger.warn("Failed to get texture of %s from %s: %s".formatted(this.uuid, this.url, e.getCause()), e);
            return;
        }
        try {
            BufferedImage head3D;
            BufferedImage textureSource = ImageIO.read(inputStream);
            BufferedImage head2D = PlayerTexture.get2DHead(textureSource);
            ImageIO.write((RenderedImage)head2D, "png", SKINS_2D_DIR.resolve(String.valueOf(this.uuid) + ".png").toFile());
            try {
                head3D = PlayerTexture.get3DHead(textureSource);
            }
            catch (NoClassDefFoundError e) {
                head3D = head2D;
            }
            ImageIO.write((RenderedImage)head3D, "png", SKINS_3D_DIR.resolve(String.valueOf(this.uuid) + ".png").toFile());
        }
        catch (Throwable t) {
            Logger.warn("Failed to process player texture with uuid of %s".formatted(this.uuid), t);
        }
    }

    private static BufferedImage get2DHead(BufferedImage source) {
        return PlayerTexture.getPart(source, 8, 8);
    }

    private static BufferedImage get3DHead(BufferedImage source) {
        BufferedImage left = PlayerTexture.getPart(source, 8, 8);
        BufferedImage right = PlayerTexture.getPart(source, 16, 8);
        BufferedImage top = PlayerTexture.getPart(source, 8, 0);
        left = PlayerTexture.scale(left, 16.0, 13.76992);
        right = PlayerTexture.scale(right, 16.0, 13.76992);
        top = PlayerTexture.scale(top, 16.0, 13.76992);
        left = PlayerTexture.shear(left);
        right = PlayerTexture.flip(PlayerTexture.shear(PlayerTexture.flip(right)));
        top = PlayerTexture.flip(PlayerTexture.shear(PlayerTexture.flip(top)));
        left = PlayerTexture.rotate(left, 0.523599);
        right = PlayerTexture.rotate(right, -0.523599);
        top = PlayerTexture.rotate(top, 0.523599);
        BufferedImage result = new BufferedImage(1024, 1024, left.getType());
        Graphics2D g2d = result.createGraphics();
        g2d.translate(-151, 257);
        g2d.drawImage((Image)left, 0, 0, null);
        g2d.translate(442, 0);
        g2d.drawImage((Image)right, 0, 0, null);
        g2d.translate(-222, -382);
        g2d.drawImage((Image)top, 0, 0, null);
        g2d.dispose();
        result = PlayerTexture.scale(result, 0.125, 0.125);
        return result;
    }

    private static BufferedImage getPart(BufferedImage source, int x, int y) {
        BufferedImage head = source.getSubimage(x, y, 8, 8);
        BufferedImage helm = source.getSubimage(x + 32, y, 8, 8);
        BufferedImage result = new BufferedImage(32, 32, source.getType());
        for (int x1 = 0; x1 < 32; ++x1) {
            for (int z1 = 0; z1 < 32; ++z1) {
                int argb = Colors.blend(helm.getRGB(x1 / 4, z1 / 4), head.getRGB(x1 / 4, z1 / 4));
                result.setRGB(x1, z1, argb);
            }
        }
        return result;
    }

    private static BufferedImage flip(BufferedImage src) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(-1.0, 1.0));
        at.concatenate(AffineTransform.getTranslateInstance(-src.getWidth(), 0.0));
        return PlayerTexture.transform(src, at);
    }

    private static BufferedImage rotate(BufferedImage src, double angle) {
        int w = src.getWidth();
        int h = src.getHeight();
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int newWidth = (int)((double)w * cos + (double)h * sin);
        int newHeight = (int)((double)h * cos + (double)w * sin);
        BufferedImage dest = new BufferedImage(newWidth, newHeight, src.getType());
        Graphics2D g2d = dest.createGraphics();
        g2d.translate((newWidth - w) / 2, (newHeight - h) / 2);
        g2d.rotate(angle, (double)w / 2.0, (double)h / 2.0);
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.dispose();
        return dest;
    }

    private static BufferedImage scale(BufferedImage src, double scaleX, double scaleY) {
        AffineTransform at = AffineTransform.getScaleInstance(scaleX, scaleY);
        return PlayerTexture.transform(src, at);
    }

    private static BufferedImage shear(BufferedImage src) {
        AffineTransform at = AffineTransform.getShearInstance(0.577375, 0.0);
        return PlayerTexture.transform(src, at);
    }

    private static BufferedImage transform(BufferedImage src, AffineTransform at) {
        return new AffineTransformOp(at, 3).filter(src, null);
    }

    static {
        try {
            Files.createDirectories(SKINS_2D_DIR, new FileAttribute[0]);
            Files.createDirectories(SKINS_3D_DIR, new FileAttribute[0]);
            STEVE_SKIN = FileUtil.getWebDir().resolve("images/skins/steve.png").toUri().toURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

