/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.util.FileUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class IconRegistry
extends Registry<IconImage> {
    private Path registeredDir;

    public void init() {
        this.registeredDir = FileUtil.getWebDir().resolve("images/icon/registered/");
        try {
            if (Files.exists(this.getDir(), new LinkOption[0])) {
                FileUtil.deleteDirectory(this.getDir());
            }
            Files.createDirectories(this.getDir(), new FileAttribute[0]);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to setup icon registry", e);
        }
    }

    public Path getDir() {
        return this.registeredDir;
    }

    @Override
    public IconImage register(String id, IconImage image) {
        try {
            String filename = id + "." + image.getType();
            File file = this.getDir().resolve(filename).toFile();
            ImageIO.write((RenderedImage)image.getImage(), image.getType(), file);
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("Failed to save image '%s'", id), e);
        }
        this.entries.put(id, image);
        return image;
    }
}

