/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import java.util.LinkedList;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.heightmap.Heightmap;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.EmptyChunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class NetherRoofRenderer
extends Renderer {
    private final Heightmap heightmap = (Heightmap)Pl3xMap.api().getHeightmapRegistry().get("none");

    public NetherRoofRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public Heightmap getHeightmap() {
        return this.heightmap;
    }

    @Override
    public void scanData(Region region) {
        int startX = region.getX() << 9;
        int startZ = region.getZ() << 9;
        LinkedList<Integer> glass = new LinkedList<Integer>();
        for (int pixelX = 0; pixelX < 512; ++pixelX) {
            int blockX = startX + pixelX;
            double lastBlockY = 0.0;
            for (int pixelZ = -1; pixelZ < 512; ++pixelZ) {
                BlockState blockstate;
                int blockZ = startZ + pixelZ;
                if (!this.getWorld().visibleBlock(blockX, blockZ)) continue;
                Pl3xMap.api().getRegionProcessor().checkPaused();
                Chunk chunk = region.getWorld().getChunk(region, blockX >> 4, blockZ >> 4);
                if (chunk instanceof EmptyChunk) continue;
                int blockY = chunk.noHeightmap() ? this.getWorld().getMaxBuildHeight() : chunk.getWorldSurfaceY(blockX, blockZ) + 1;
                int fluidY = 0;
                BlockState fluidstate = null;
                do {
                    if ((blockstate = chunk.getBlockState(blockX, --blockY, blockZ)).getBlock().isFluid()) {
                        if (fluidstate != null) continue;
                        fluidY = blockY;
                        fluidstate = blockstate;
                        continue;
                    }
                    if (this.getWorld().getConfig().RENDER_TRANSLUCENT_GLASS && blockstate.getBlock().isGlass()) {
                        glass.addFirst(Colors.setAlpha(153, blockstate.getBlock().color()));
                        continue;
                    }
                    if (blockstate.getBlock().color() > 0) break;
                } while (blockY > this.getWorld().getMinBuildHeight());
                Chunk.BlockData blockData = Chunk.BlockData.of(blockY, fluidY, blockstate, fluidstate, glass);
                int pixelColor = this.basicPixelColor(region, blockData, blockX, blockZ);
                this.getTileImage().setPixel(blockX, blockZ, pixelColor);
                if (blockstate.getBlock().isFlat()) {
                    --blockY;
                }
                glass.clear();
                lastBlockY = blockY;
            }
        }
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
    }
}

