/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import java.util.Locale;
import java.util.Objects;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.TileImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.renderer.heightmap.Heightmap;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.Blocks;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Renderer
extends Keyed {
    private final RegionScanTask task;
    private final String name;
    private final World world;
    private final Heightmap heightmap;
    private TileImage tileImage;

    public Renderer(RegionScanTask task, Builder builder) {
        super(builder.getKey());
        this.task = task;
        this.name = builder.getName();
        this.world = task.getWorld();
        String key = this.getWorld().getConfig().RENDER_HEIGHTMAP_TYPE.toLowerCase(Locale.ROOT);
        this.heightmap = (Heightmap)Pl3xMap.api().getHeightmapRegistry().get(key);
    }

    public RegionScanTask getRegionScanTask() {
        return this.task;
    }

    public World getWorld() {
        return this.world;
    }

    public String getName() {
        return this.name;
    }

    public Heightmap getHeightmap() {
        return this.heightmap;
    }

    public TileImage getTileImage() {
        return this.tileImage;
    }

    public void allocateData(Point region) {
        this.tileImage = new TileImage(this.getKey(), this.getWorld(), region);
    }

    public void saveData(Point region) {
        this.tileImage.saveToDisk();
    }

    public void scanData(Region region) {
        int cX = region.getX() << 5;
        int cZ = region.getZ() << 5;
        for (int chunkX = cX; chunkX < cX + 32; ++chunkX) {
            int bX = chunkX << 4;
            for (int chunkZ = cZ; chunkZ < cZ + 32; ++chunkZ) {
                if (!this.getWorld().visibleChunk(chunkX, chunkZ)) continue;
                int bZ = chunkZ << 4;
                Chunk chunk = region.getChunk(chunkX, chunkZ);
                for (int blockX = bX; blockX < bX + 16; ++blockX) {
                    for (int blockZ = bZ; blockZ < bZ + 16; ++blockZ) {
                        Chunk.BlockData data;
                        Pl3xMap.api().getRegionProcessor().checkPaused();
                        if (!this.getWorld().visibleBlock(blockX, blockZ) || (data = chunk.getData(blockX, blockZ)) == null) continue;
                        this.scanBlock(region, chunk, data, blockX, blockZ);
                    }
                }
            }
        }
    }

    public abstract void scanBlock(Region var1, Chunk var2, Chunk.BlockData var3, int var4, int var5);

    public int basicPixelColor(Region region, Chunk.BlockData data, int blockX, int blockZ) {
        Biome biome = data.getBiome(region, blockX, blockZ);
        int pixelColor = 0;
        if ((data.getFluidState() == null || region.getWorld().getConfig().RENDER_TRANSLUCENT_FLUIDS) && (pixelColor = Colors.fixBlockColor(region, biome, data.getBlockState(), blockX, blockZ)) != 0) {
            pixelColor = Colors.setAlpha(255, pixelColor);
            pixelColor = Colors.blend(this.getHeightmap().getColor(region, blockX, blockZ), pixelColor);
        }
        pixelColor = this.processFluids(region.getWorld().getConfig().RENDER_TRANSLUCENT_FLUIDS, region, biome, data, blockX, blockZ, pixelColor);
        for (int color : data.getGlassColors()) {
            pixelColor = Colors.blend(color, pixelColor);
        }
        return pixelColor;
    }

    public int processFluids(boolean translucentFluid, Region region, Biome biome, Chunk.BlockData data, int blockX, int blockZ, int pixelColor) {
        if (data.getFluidState() != null) {
            int fluidDepth = data.getFluidY() - data.getBlockY();
            if (translucentFluid) {
                int fluidColor = this.fancyFluids(region, biome, data.getFluidState(), blockX, blockZ, (float)fluidDepth * 0.025f);
                return Colors.blend(fluidColor, pixelColor);
            }
            double diffY = (double)fluidDepth * 0.1 + (double)(blockX + blockZ & 1) * 0.2;
            return Colors.shade(data.getFluidState().getBlock().isWater() ? Colors.getWaterColor(region, biome, blockX, blockZ) : Blocks.LAVA.color(), diffY < 0.5 ? 255 : (diffY > 0.9 ? 180 : 220));
        }
        return pixelColor;
    }

    public int fancyFluids(Region region, Biome biome, BlockState fluidstate, int blockX, int blockZ, float depth) {
        int color;
        if (fluidstate.getBlock().isWater()) {
            color = Colors.getWaterColor(region, biome, blockX, blockZ);
            color = Colors.lerpARGB(color, -16777216, Mathf.clamp(0.0f, 0.45f, Easing.cubicOut(depth / 1.5f)));
            color = Colors.setAlpha((int)(Easing.quinticOut(Mathf.clamp(0.0f, 1.0f, depth * 5.0f)) * 255.0f), color);
        } else {
            color = Colors.lerpARGB(fluidstate.getBlock().color(), -16777216, Mathf.clamp(0.0f, 0.3f, Easing.cubicOut(depth / 1.5f)));
            color = Colors.setAlpha(255, color);
        }
        return color;
    }

    public int calculateLight(Chunk chunk, @Nullable BlockState fluidState, int blockX, int blockY, int blockZ, int fluidY, int pixelColor) {
        int blockLight = fluidState != null && !fluidState.getBlock().isWater() ? 15 : chunk.getLight(blockX, (fluidState == null ? blockY : fluidY) + 1, blockZ);
        int alpha = (int)(204.0f * Mathf.inverseLerp(4.0f, 15.0f, blockLight));
        int darkness = Mathf.clamp(0, 204, 204 - alpha);
        return Colors.blend(darkness << 24, pixelColor);
    }

    public static final class Builder
    extends Keyed {
        private final String name;
        private final Class<? extends Renderer> clazz;

        public Builder(String key, String name, Class<? extends Renderer> clazz) {
            super(key);
            this.name = name;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Renderer> getClazz() {
            return this.clazz;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            return this.getKey().equals(other.getKey()) && Objects.equals(this.name, other.name) && Objects.equals(this.clazz, other.clazz);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey(), this.name, this.clazz);
        }

        @Override
        public String toString() {
            return "Builder[key=" + this.getKey() + ", name=" + this.name + ", clazz=" + String.valueOf(this.clazz) + "]";
        }
    }

    public static class Easing {
        public static float cubicOut(float t) {
            return 1.0f + (t -= 1.0f) * t * t;
        }

        public static float quinticOut(float t) {
            return 1.0f + (t -= 1.0f) * t * t * t * t;
        }
    }
}

