/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.progress;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.renderer.progress.CPSTracker;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Progress
implements Runnable {
    private final CPSTracker cpsTracker = new CPSTracker();
    private final AtomicLong processedChunks = new AtomicLong(0L);
    private final AtomicLong processedRegions = new AtomicLong(0L);
    private final Executor executor;
    private CompletableFuture<Void> future;
    private World world;
    private long prevProcessedChunks = 0L;
    private long totalChunks;
    private long totalRegions;
    private float percent;
    private double cps;
    private String eta = Lang.PROGRESS_ETA_UNKNOWN;

    public Progress() {
        this.executor = Pl3xMap.ThreadFactory.createService("Pl3xMap-Progress");
        this.start(1000L);
    }

    public void start(long delay) {
        this.future = CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.run();
            this.start(1000L);
        }, this.executor);
    }

    public void stop() {
        if (this.future != null) {
            boolean result = this.future.cancel(true);
            Logger.debug("Stopped progress tracker: " + result);
        }
    }

    public void finish() {
        this.world = null;
        this.setTotalChunks(0L);
        this.setProcessedChunks(0L);
        this.setTotalRegions(0L);
        this.setProcessedRegions(0L);
        this.prevProcessedChunks = 0L;
        this.percent = 0.0f;
        this.cps = 0.0;
        this.eta = Lang.PROGRESS_ETA_UNKNOWN;
    }

    public @Nullable World getWorld() {
        return this.world;
    }

    public void setWorld(@Nullable World world) {
        this.world = world;
    }

    public long getTotalChunks() {
        return this.totalChunks;
    }

    public void setTotalChunks(long totalChunks) {
        this.totalChunks = totalChunks;
    }

    public long getTotalRegions() {
        return this.totalRegions;
    }

    public void setTotalRegions(long totalRegions) {
        this.totalRegions = totalRegions;
    }

    public void increment() {
        this.processedRegions.set(this.processedRegions.get() + 1L);
        this.processedChunks.set(this.processedChunks.get() + 1024L);
    }

    public float getPercent() {
        return this.percent;
    }

    public double getCPS() {
        return this.cps;
    }

    public String getETA() {
        return this.eta;
    }

    public AtomicLong getProcessedChunks() {
        return this.processedChunks;
    }

    public void setProcessedChunks(long processedChunks) {
        this.getProcessedChunks().set(processedChunks);
        this.prevProcessedChunks = processedChunks;
    }

    public AtomicLong getProcessedRegions() {
        return this.processedRegions;
    }

    public void setProcessedRegions(long processedRegions) {
        this.getProcessedRegions().set(processedRegions);
    }

    @Override
    public void run() {
        try {
            this.runProgress();
        }
        catch (Throwable t) {
            Logger.severe("Failed to run progress", t);
        }
    }

    private void runProgress() {
        if (this.world == null || Pl3xMap.api().getRegionProcessor().isPaused()) {
            return;
        }
        long processedChunks = this.getProcessedChunks().get();
        this.cpsTracker.add(processedChunks - this.prevProcessedChunks);
        this.prevProcessedChunks = processedChunks;
        this.percent = (float)processedChunks / (float)this.getTotalChunks() * 100.0f;
        this.cps = this.cpsTracker.average();
        if (this.cps > 0.0) {
            long timeLeft = (this.totalChunks - processedChunks) / (long)this.cps * 1000L;
            this.eta = Progress.formatMilliseconds(timeLeft);
        } else {
            this.eta = Lang.PROGRESS_ETA_UNKNOWN;
        }
    }

    public static String formatMilliseconds(long time) {
        int hrs = (int)TimeUnit.MILLISECONDS.toHours(time);
        int min = (int)TimeUnit.MILLISECONDS.toMinutes(time) % 60;
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(time) % 60;
        if (hrs > 0) {
            return String.format("%dh %dm %ds", hrs, min, sec);
        }
        if (min > 0) {
            return String.format("%dm %ds", min, sec);
        }
        return String.format("%ds", sec);
    }
}

