/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.registry.RendererRegistry;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Region;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RegionScanTask
implements Runnable {
    private final World world;
    private final Point regionPos;
    private final Map<String, Renderer> renderers = new LinkedHashMap<String, Renderer>();

    public RegionScanTask(World world, Point regionPos) {
        this.world = world;
        this.regionPos = regionPos;
        RendererRegistry registry = Pl3xMap.api().getRendererRegistry();
        ArrayList<Renderer.Builder> rendererBuilders = new ArrayList<Renderer.Builder>(this.world.getRenderers().values());
        String blockInfo = this.world.getConfig().UI_BLOCKINFO;
        if (blockInfo != null && !blockInfo.isEmpty()) {
            rendererBuilders.add((Renderer.Builder)registry.get("blockinfo"));
        }
        rendererBuilders.forEach(builder -> {
            Renderer renderer = registry.createRenderer(this, (Renderer.Builder)builder);
            this.renderers.put(renderer.getKey(), renderer);
        });
    }

    public World getWorld() {
        return this.world;
    }

    public @Nullable Renderer getRenderer(String id) {
        return this.renderers.get(id);
    }

    public void cleanup() {
        this.renderers.clear();
    }

    @Override
    public void run() {
        try {
            Logger.debug("[" + this.world.getName() + "] Scanning " + String.valueOf(this.regionPos) + " -- " + Thread.currentThread().getName());
            Pl3xMap.api().getRegionProcessor().checkPaused();
            this.allocateImages();
            Pl3xMap.api().getRegionProcessor().checkPaused();
            this.scanRegion(this.loadRegion());
            Pl3xMap.api().getRegionProcessor().checkPaused();
            this.saveImages();
        }
        catch (Throwable t) {
            Logger.severe("Failed to scan world %s at region %s".formatted(this.world.getName(), this.regionPos), t);
        }
    }

    private void allocateImages() {
        for (Renderer renderer : this.renderers.values()) {
            Pl3xMap.api().getRegionProcessor().checkPaused();
            renderer.allocateData(this.regionPos);
        }
    }

    private Region loadRegion() {
        Region region = this.world.getRegion(null, this.regionPos.x(), this.regionPos.z());
        try {
            region.loadChunks();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return region;
    }

    private void scanRegion(Region region) {
        for (Renderer renderer : this.renderers.values()) {
            Pl3xMap.api().getRegionProcessor().checkPaused();
            renderer.scanData(region);
        }
        Pl3xMap.api().getRegionProcessor().getProgress().increment();
    }

    private void saveImages() {
        for (Renderer renderer : this.renderers.values()) {
            Pl3xMap.api().getRegionProcessor().checkPaused();
            renderer.saveData(this.regionPos);
        }
        this.world.getRegionModifiedState().set(Mathf.asLong(this.regionPos), System.currentTimeMillis());
    }
}

