/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import java.util.ArrayList;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.renderer.task.AbstractDataTask;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.util.TickUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UpdateMarkerData
extends AbstractDataTask {
    public UpdateMarkerData(World world) {
        super(TickUtil.toTicks(1), true, world, "Pl3xMap-Markers");
    }

    @Override
    public void parse() {
        ArrayList layers = new ArrayList();
        this.world.getLayerRegistry().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Layer layer = (Layer)entry.getValue();
            try {
                layers.add(layer.toJson());
                long now = System.currentTimeMillis();
                long lastUpdated = this.lastUpdated.getOrDefault(key, 0L);
                if (now - lastUpdated > (long)Math.max(TickUtil.toMilliseconds(layer.getUpdateInterval()), 1000)) {
                    ArrayList list = new ArrayList(layer.getMarkers());
                    FileUtil.writeJson(this.gson.toJson(list), this.world.getMarkersDirectory().resolve(key.replace(":", "-") + ".json"));
                    this.lastUpdated.put(key, now);
                }
            }
            catch (Throwable t) {
                Logger.severe("Failed to process layer " + key + " for world " + this.world.getName(), t);
            }
        });
        FileUtil.writeJson(this.gson.toJson(layers), this.world.getTilesDirectory().resolve("markers.json"));
    }
}

