/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Colors {
    private static final int[] mapGrass;
    private static final int[] mapDryFoliage;
    private static final int[] mapFoliage;

    private static int[] getColorsFromImage(BufferedImage image) {
        int[] map = new int[65536];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                int rgb = image.getRGB(x, y);
                map[x + y * 256] = Colors.red(rgb) << 16 | Colors.green(rgb) << 8 | Colors.blue(rgb);
            }
        }
        return map;
    }

    public static int getDefaultGrassColor(double temperature, double humidity) {
        return Colors.getDefaultColor(temperature, humidity, mapGrass);
    }

    public static int getDefaultDryFoliageColor(double temperature, double humidity) {
        return Colors.getDefaultColor(temperature, humidity, mapDryFoliage);
    }

    public static int getDefaultFoliageColor(double temperature, double humidity) {
        return Colors.getDefaultColor(temperature, humidity, mapFoliage);
    }

    private static int getDefaultColor(double temperature, double humidity, int[] map) {
        int j = (int)((1.0 - humidity * temperature) * 255.0);
        int i = (int)((1.0 - temperature) * 255.0);
        int k = j << 8 | i;
        return k > map.length ? 0 : map[k];
    }

    public static int rgb2bgr(int color) {
        int a2 = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        return a2 << 24 | b2 << 16 | g << 8 | r;
    }

    public static int lerpRGB(int color0, int color1, float delta) {
        if (color0 == color1) {
            return color0;
        }
        if (delta >= 1.0f) {
            return color1;
        }
        if (delta <= 0.0f) {
            return color0;
        }
        return Colors.rgb((int)Mathf.lerp(Colors.red(color0), Colors.red(color1), delta), (int)Mathf.lerp(Colors.green(color0), Colors.green(color1), delta), (int)Mathf.lerp(Colors.blue(color0), Colors.blue(color1), delta));
    }

    public static int lerpARGB(int color0, int color1, float delta) {
        if (color0 == color1) {
            return color0;
        }
        if (delta >= 1.0f) {
            return color1;
        }
        if (delta <= 0.0f) {
            return color0;
        }
        return Colors.argb((int)Mathf.lerp(Colors.alpha(color0), Colors.alpha(color1), delta), (int)Mathf.lerp(Colors.red(color0), Colors.red(color1), delta), (int)Mathf.lerp(Colors.green(color0), Colors.green(color1), delta), (int)Mathf.lerp(Colors.blue(color0), Colors.blue(color1), delta));
    }

    public static int lerpHSB(int color0, int color1, float delta) {
        return Colors.lerpHSB(color0, color1, delta, true);
    }

    public static int lerpHSB(int color0, int color1, float delta, boolean useShortestAngle) {
        float[] hsb0 = Color.RGBtoHSB(Colors.red(color0), Colors.green(color0), Colors.blue(color0), null);
        float[] hsb1 = Color.RGBtoHSB(Colors.red(color1), Colors.green(color1), Colors.blue(color1), null);
        return Colors.setAlpha((int)Mathf.lerp(Colors.alpha(color0), Colors.alpha(color1), delta), Color.HSBtoRGB(useShortestAngle ? Colors.lerpShortestAngle(hsb0[0], hsb1[0], delta) : Mathf.lerp(hsb0[0], hsb1[0], delta), Mathf.lerp(hsb0[1], hsb1[1], delta), Mathf.lerp(hsb0[2], hsb1[2], delta)));
    }

    public static int inverseLerpRGB(int color0, int color1, float delta) {
        if (color0 == color1) {
            return color0;
        }
        if (delta >= 1.0f) {
            return color1;
        }
        if (delta <= 0.0f) {
            return color0;
        }
        return Colors.rgb((int)Mathf.inverseLerp(Colors.red(color0), Colors.red(color1), delta), (int)Mathf.inverseLerp(Colors.green(color0), Colors.green(color1), delta), (int)Mathf.inverseLerp(Colors.blue(color0), Colors.blue(color1), delta));
    }

    public static int inverseLerpARGB(int color0, int color1, float delta) {
        if (color0 == color1) {
            return color0;
        }
        if (delta >= 1.0f) {
            return color1;
        }
        if (delta <= 0.0f) {
            return color0;
        }
        return Colors.argb((int)Mathf.inverseLerp(Colors.alpha(color0), Colors.alpha(color1), delta), (int)Mathf.inverseLerp(Colors.red(color0), Colors.red(color1), delta), (int)Mathf.inverseLerp(Colors.green(color0), Colors.green(color1), delta), (int)Mathf.inverseLerp(Colors.blue(color0), Colors.blue(color1), delta));
    }

    public static int inverseLerpHSB(int color0, int color1, float delta) {
        return Colors.inverseLerpHSB(color0, color1, delta, true);
    }

    public static int inverseLerpHSB(int color0, int color1, float delta, boolean useShortestAngle) {
        float[] hsb0 = Color.RGBtoHSB(Colors.red(color0), Colors.green(color0), Colors.blue(color0), null);
        float[] hsb1 = Color.RGBtoHSB(Colors.red(color1), Colors.green(color1), Colors.blue(color1), null);
        return Colors.setAlpha((int)Mathf.inverseLerp(Colors.alpha(color0), Colors.alpha(color1), delta), Color.HSBtoRGB(useShortestAngle ? Colors.lerpShortestAngle(hsb0[0], hsb1[0], delta) : Mathf.inverseLerp(hsb0[0], hsb1[0], delta), Mathf.inverseLerp(hsb0[1], hsb1[1], delta), Mathf.inverseLerp(hsb0[2], hsb1[2], delta)));
    }

    public static float lerpShortestAngle(float start, float end, float delta) {
        float distCW = end >= start ? end - start : 1.0f - (start - end);
        float distCCW = start >= end ? start - end : 1.0f - (end - start);
        float direction = distCW <= distCCW ? distCW : -1.0f * distCCW;
        return start + direction * delta;
    }

    public static int blend(int color0, int color1) {
        double a0 = (double)Colors.alpha(color0) / 255.0;
        double a1 = (double)Colors.alpha(color1) / 255.0;
        double a2 = a0 + a1 * (1.0 - a0);
        double r = ((double)Colors.red(color0) * a0 + (double)Colors.red(color1) * a1 * (1.0 - a0)) / a2;
        double g = ((double)Colors.green(color0) * a0 + (double)Colors.green(color1) * a1 * (1.0 - a0)) / a2;
        double b2 = ((double)Colors.blue(color0) * a0 + (double)Colors.blue(color1) * a1 * (1.0 - a0)) / a2;
        return Colors.argb((int)a2 * 255, (int)r, (int)g, (int)b2);
    }

    public static int mix(int color0, int color1) {
        int r = Colors.red(color0) + Colors.red(color1);
        int g = Colors.green(color0) + Colors.green(color1);
        int b2 = Colors.blue(color0) + Colors.blue(color1);
        return Colors.rgb(r >> 1, g >> 1, b2 >> 1);
    }

    public static int shade(int color, int shade) {
        float ratio = (float)shade / 255.0f;
        int r = (int)((float)(color >> 16 & 0xFF) * ratio);
        int g = (int)((float)(color >> 8 & 0xFF) * ratio);
        int b2 = (int)((float)(color & 0xFF) * ratio);
        return 0xFF000000 | r << 16 | g << 8 | b2;
    }

    public static int getDryFoliageColor(Region region, Biome biome, int color, int x, int z) {
        return Colors.sampleNeighbors(region, biome, x, z, (biome2, x2, z2) -> Colors.mix(biome2.dryFoliage(), color));
    }

    public static int getFoliageColor(Region region, Biome biome, int color, int x, int z) {
        return Colors.sampleNeighbors(region, biome, x, z, (biome2, x2, z2) -> Colors.mix(biome2.foliage(), color));
    }

    public static int getGrassColor(Region region, Biome biome, int color, int x, int z) {
        return Colors.sampleNeighbors(region, biome, x, z, (biome2, x2, z2) -> Colors.mix(biome2.grass(x2, z2), color));
    }

    public static int getWaterColor(Region region, Biome biome, int x, int z) {
        return Colors.sampleNeighbors(region, biome, x, z, (biome2, x2, z2) -> biome2.water());
    }

    private static int sampleNeighbors(Region region, Biome biome, int x, int z, Sampler colorSampler) {
        int radius = region.getWorld().getConfig().RENDER_BIOME_BLEND;
        int color = colorSampler.apply(biome, x, z);
        if (radius < 1) {
            return color;
        }
        int red = Colors.red(color);
        int green = Colors.green(color);
        int blue = Colors.blue(color);
        int count = 1;
        for (int x2 = x - radius; x2 < x + radius; ++x2) {
            for (int z2 = z - radius; z2 < z + radius; ++z2) {
                int color2;
                Chunk.BlockData data;
                if (x2 == x && z2 == z || (data = region.getWorld().getChunk(region, x2 >> 4, z2 >> 4).getData(x2, z2)) == null || (color2 = colorSampler.apply(data.getBiome(region, x2, z2), x2, z2).intValue()) <= 0) continue;
                red += Colors.red(color2);
                green += Colors.green(color2);
                blue += Colors.blue(color2);
                ++count;
            }
        }
        return Colors.rgb(red / count, green / count, blue / count);
    }

    public static int fixBlockColor(Region region, Biome biome, BlockState blockstate, int x, int z) {
        int color = blockstate.getBlock().color();
        if (color <= 0) {
            return 0;
        }
        if (blockstate.getBlock().isDryFoliage()) {
            return Colors.getDryFoliageColor(region, biome, color, x, z);
        }
        if (blockstate.getBlock().isFoliage()) {
            return Colors.getFoliageColor(region, biome, color, x, z);
        }
        if (blockstate.getBlock().isGrass()) {
            return Colors.getGrassColor(region, biome, color, x, z);
        }
        if (blockstate.getBlock().isWater()) {
            return Colors.getWaterColor(region, biome, x, z);
        }
        String key = blockstate.getBlock().getKey();
        if (key.equals("minecraft:melon_stem") || key.equals("minecraft:pumpkin_stem")) {
            byte age = blockstate.getAge();
            return Colors.rgb(age << 5, 255 - (age << 3), age << 2);
        }
        if (key.equals("minecraft:wheat")) {
            return Colors.lerpRGB(31744, 14465893, (float)(blockstate.getAge() + 1) / 8.0f);
        }
        if (key.equals("minecraft:redstone_wire")) {
            return Pl3xMap.api().getColorForPower(blockstate.getPower());
        }
        if (key.equals("minecraft:cocoa")) {
            return switch (blockstate.getAge()) {
                case 0 -> 6973486;
                case 1 -> 6637345;
                default -> 7354133;
            };
        }
        if (key.equals("minecraft:farmland")) {
            return blockstate.getMoisture() >= 7 ? 5319695 : 9332294;
        }
        return blockstate.getBlock().color();
    }

    public static int mul(int color, float multiplier) {
        return color & 0xFF000000 | (int)Mathf.clamp(0.0f, 255.0f, (float)(color >> 16 & 0xFF) * multiplier) << 16 | (int)Mathf.clamp(0.0f, 255.0f, (float)(color >> 8 & 0xFF) * multiplier) << 8 | (int)Mathf.clamp(0.0f, 255.0f, (float)(color & 0xFF) * multiplier);
    }

    public static int rgb(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int alpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static int setAlpha(int alpha, int argb) {
        return alpha << 24 | argb & 0xFFFFFF;
    }

    public static int fromHex(String color) {
        return (int)Long.parseLong(color.replace("#", ""), 16);
    }

    public static String toHex(int argb) {
        return String.format("#%06X", 0xFFFFFF & argb);
    }

    public static String toHex8(int argb) {
        return String.format("#%08X", argb);
    }

    static {
        int[] foliage;
        int[] dryFoliage;
        int[] grass;
        try {
            BufferedImage imgFoliage;
            BufferedImage imgDryFoliage;
            BufferedImage imgGrass;
            Path imagesDir = FileUtil.getWebDir().resolve("images");
            try {
                imgGrass = ImageIO.read(imagesDir.resolve("grass.png").toFile());
                imgDryFoliage = ImageIO.read(imagesDir.resolve("dry_foliage.png").toFile());
                imgFoliage = ImageIO.read(imagesDir.resolve("foliage.png").toFile());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read color images", e);
            }
            grass = Colors.getColorsFromImage(imgGrass);
            dryFoliage = Colors.getColorsFromImage(imgDryFoliage);
            foliage = Colors.getColorsFromImage(imgFoliage);
        }
        catch (Throwable ignore) {
            grass = new int[]{};
            dryFoliage = new int[]{};
            foliage = new int[]{};
        }
        mapGrass = grass;
        mapDryFoliage = dryFoliage;
        mapFoliage = foliage;
    }

    @FunctionalInterface
    public static interface Sampler {
        public Integer apply(Biome var1, Integer var2, Integer var3);
    }
}

