/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FileUtil {
    public static Path getTilesDir() {
        return FileUtil.getWebDir().resolve("tiles");
    }

    public static Path getWebDir() {
        return Config.WEB_DIR.startsWith("/") ? Path.of(Config.WEB_DIR, new String[0]) : Pl3xMap.api().getMainDir().resolve(Config.WEB_DIR);
    }

    public static void extractFile(Class<?> clazz, String filename, Path outDir, boolean replace) {
        try (InputStream in = clazz.getResourceAsStream("/" + filename);){
            if (in == null) {
                throw new RuntimeException("Could not read file from jar! (" + filename + ")");
            }
            Path path = outDir.resolve(filename);
            if (!Files.exists(path, new LinkOption[0]) || replace) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void extractDir(String sourceDir, Path outDir, boolean replace) {
        try (JarFile jarFile = new JarFile(Pl3xMap.api().getJarPath().toFile());){
            Logger.debug("Extracting " + sourceDir + " directory from jar...");
            String path = sourceDir.substring(1);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                Path file = outDir.resolve(name.substring(path.length()));
                boolean exists = Files.exists(file, new LinkOption[0]);
                if (!replace && exists) {
                    Logger.debug("  <yellow>exists</yellow>   " + name);
                    continue;
                }
                if (entry.isDirectory()) {
                    if (!exists) {
                        try {
                            Files.createDirectories(file, new FileAttribute[0]);
                            Logger.debug("  <green>creating</green> " + name);
                        }
                        catch (IOException e) {
                            Logger.debug("  <red><bold>failed</bold></red>   " + name);
                        }
                        continue;
                    }
                    Logger.debug("  <yellow>exists</yellow>   " + name);
                    continue;
                }
                try (BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.toFile()));){
                    int readCount;
                    byte[] buffer = new byte[4096];
                    while ((readCount = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, readCount);
                    }
                    ((OutputStream)out).flush();
                    Logger.debug("  <green>writing</green>  " + name);
                }
                catch (IOException e) {
                    Logger.debug("  <red><bold>failed</bold></red>   " + name);
                    Logger.severe("Failed to extract file (" + name + ") from jar!", e);
                }
            }
        }
        catch (IOException e) {
            Logger.severe("Failed to extract " + sourceDir + " directory from jar", e);
        }
    }

    public static void writeJson(String str, Path file) {
        Path tmp = FileUtil.tmp(file);
        try (OutputStream fileOut = Files.newOutputStream(FileUtil.mkDirs(tmp), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(fileOut);){
            writer.write(str);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            FileUtil.atomicMove(tmp, file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveGzip(String json, Path file) throws IOException {
        Path tmp = FileUtil.tmp(file);
        try (OutputStream fileOut = Files.newOutputStream(FileUtil.mkDirs(tmp), new OpenOption[0]);
             GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);
             OutputStreamWriter writer = new OutputStreamWriter(gzipOut);){
            writer.write(json);
            ((Writer)writer).flush();
        }
        FileUtil.atomicMove(tmp, file);
    }

    public static void saveGzip(byte[] bytes, Path file) throws IOException {
        Path tmp = FileUtil.tmp(file);
        try (OutputStream fileOut = Files.newOutputStream(FileUtil.mkDirs(tmp), new OpenOption[0]);
             GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);){
            gzipOut.write(bytes);
            gzipOut.flush();
        }
        FileUtil.atomicMove(tmp, file);
    }

    public static void readGzip(Path file, ByteBuffer buffer) throws IOException {
        try (InputStream fileIn = Files.newInputStream(file, new OpenOption[0]);
             GZIPInputStream gzipIn = new GZIPInputStream(fileIn);){
            byte[] bytes = gzipIn.readAllBytes();
            gzipIn.close();
            buffer.put(bytes);
        }
    }

    /*
     * Exception decompiling
     */
    public static String readGzip(Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path tmp(Path file) {
        return file.resolveSibling("." + file.getFileName().toString() + ".tmp");
    }

    public static void atomicMove(Path source, Path target) throws IOException {
        try {
            FileUtil.atomicMove(source, target, 0);
        }
        catch (AccessDeniedException | NoSuchFileException fileSystemException) {
            // empty catch block
        }
    }

    private static void atomicMove(Path source, Path target, int attempt) throws IOException {
        block8: {
            try {
                com.google.common.io.Files.move((File)source.toFile(), (File)target.toFile());
                Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AccessDeniedException e) {
                if (attempt < 5) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    FileUtil.atomicMove(source, target, ++attempt);
                }
                if (!source.getFileName().toString().endsWith(".tmp")) break block8;
                try {
                    Files.delete(source);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static Path mkDirs(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }

    public static void createDirs(Path dirPath) {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void deleteDirectory(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static Collection<Point> regionPathsToPoints(World world, @Nullable Collection<Path> paths, boolean ignoreTimestamp) {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Point> regions = new ArrayList<Point>();
        for (Path file : paths) {
            if (file.toFile().length() <= 0L) {
                Logger.debug("Skipping zero length region file: " + String.valueOf(file.getFileName()));
                continue;
            }
            try {
                String[] split = file.getFileName().toString().split("\\.");
                int rX = Integer.parseInt(split[1]);
                int rZ = Integer.parseInt(split[2]);
                if (!world.visibleRegion(rX, rZ)) {
                    Logger.debug("Skipping region outside of visible areas: " + String.valueOf(file.getFileName()));
                    continue;
                }
                if (ignoreTimestamp) {
                    regions.add(Point.of(rX, rZ));
                    continue;
                }
                long storedModifiedTime = world.getRegionModifiedState().get(Mathf.asLong(rX, rZ));
                long actualModifiedTime = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (actualModifiedTime <= storedModifiedTime) continue;
                Logger.debug("Found modified region file: " + String.valueOf(file.getFileName()));
                regions.add(Point.of(rX, rZ));
            }
            catch (NumberFormatException split) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return regions;
    }
}

