/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.pl3x.map.core.markers.Point;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SpiralIterator
implements Iterator<Point> {
    protected int currentX;
    protected int currentZ;
    protected long totalStepsInLeg;
    protected long currentStepInLeg;
    protected long legAxis;
    protected Direction direction = Direction.WEST;

    public SpiralIterator(int centerX, int centerZ) {
        this.currentX = centerX;
        this.currentZ = centerZ;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Point next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Point point = Point.of(this.currentX, this.currentZ);
        switch (this.direction.ordinal()) {
            case 1: {
                ++this.currentZ;
                break;
            }
            case 2: {
                --this.currentX;
                break;
            }
            case 3: {
                --this.currentZ;
                break;
            }
            default: {
                ++this.currentX;
            }
        }
        ++this.currentStepInLeg;
        if (this.currentStepInLeg > this.totalStepsInLeg) {
            this.direction = this.direction.next();
            this.currentStepInLeg = 0L;
            ++this.legAxis;
            if (this.legAxis > 1L) {
                this.legAxis = 0L;
                ++this.totalStepsInLeg;
            }
        }
        return point;
    }

    public static enum Direction {
        EAST,
        SOUTH,
        WEST,
        NORTH;

        private static final Direction[] VALUES;

        public Direction next() {
            return VALUES[this.ordinal() + 1 & 3];
        }

        static {
            VALUES = Direction.values();
        }
    }
}

