/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4543;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.ColorsConfig;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FabricWorld
extends World {
    private final class_3218 level;

    public FabricWorld(class_3218 level, String name) {
        super(name, level.method_8412(), Point.of(level.method_8401().method_74893().method_74897().method_10263(), level.method_8401().method_74893().method_74897().method_10260()), World.Type.get(level.method_27983().method_29177().toString()), level.method_14178().method_17981().field_17664.getParent().resolve("region"));
        this.level = level;
        if (!this.isEnabled()) {
            return;
        }
        this.init();
        Set entries = level.method_30349().method_30530(class_7924.field_41236).method_29722();
        for (Map.Entry entry : entries) {
            String id = ((class_5321)entry.getKey()).method_29177().toString();
            class_1959 biome = (class_1959)entry.getValue();
            float temperature = Mathf.clamp(0.0f, 1.0f, biome.method_8712());
            float humidity = Mathf.clamp(0.0f, 1.0f, biome.field_26393.comp_846());
            this.getBiomeRegistry().register(id, ColorsConfig.BIOME_COLORS.getOrDefault(id, 0), ColorsConfig.BIOME_DRY_FOLIAGE.getOrDefault(id, biome.method_24377().method_68147().orElse(Colors.getDefaultDryFoliageColor(temperature, humidity))), ColorsConfig.BIOME_FOLIAGE.getOrDefault(id, biome.method_24377().method_30811().orElse(Colors.getDefaultFoliageColor(temperature, humidity))), ColorsConfig.BIOME_GRASS.getOrDefault(id, biome.method_24377().method_30812().orElse(Colors.getDefaultGrassColor(temperature, humidity))), ColorsConfig.BIOME_WATER.getOrDefault(id, biome.method_24377().method_24388()), (x, z, color) -> biome.method_24377().method_30814().method_30823((double)x, (double)z, color));
        }
        this.getBiomeRegistry().saveToDisk(this);
        Pl3xMap.api().getEventRegistry().callEvent(new WorldLoadedEvent(this));
    }

    @Override
    public <T> T getLevel() {
        return (T)this.level;
    }

    @Override
    public long hashSeed(long seed) {
        return class_4543.method_27984((long)seed);
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public int getMinBuildHeight() {
        return this.level.method_31607();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.level.method_31600() + 1;
    }

    @Override
    public int getDimensionHeight() {
        return this.level.method_8597().comp_652();
    }

    @Override
    public int getLogicalHeight() {
        return this.level.method_32819();
    }

    @Override
    public double getBorderMinX() {
        return this.level.method_8621().method_11976();
    }

    @Override
    public double getBorderMinZ() {
        return this.level.method_8621().method_11958();
    }

    @Override
    public double getBorderMaxX() {
        return this.level.method_8621().method_11963();
    }

    @Override
    public double getBorderMaxZ() {
        return this.level.method_8621().method_11977();
    }

    @Override
    public Collection<Player> getPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (class_3222 serverPlayer : ((class_3218)this.getLevel()).method_18456()) {
            Player player = Pl3xMap.api().getPlayerRegistry().get(serverPlayer.method_5667());
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public String toString() {
        return "FabricWorld{name=" + this.getName() + ",seed=" + this.getSeed() + ",spawn=" + String.valueOf(this.getSpawn()) + "}";
    }
}

