/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.server;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.kyori.adventure.platform.AudienceProvider;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.class_155;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2457;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3175;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4638;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6796;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.server.ServerLoadedEvent;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.player.PlayerListener;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.World;
import net.pl3x.map.fabric.server.FabricNetwork;
import net.pl3x.map.fabric.server.FabricPlayer;
import net.pl3x.map.fabric.server.FabricWorld;
import net.pl3x.map.fabric.server.command.FabricCommandManager;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Pl3xMapFabricServer
extends Pl3xMap
implements DedicatedServerModInitializer {
    private final class_5819 randomSource = class_5819.method_43050();
    private final PlayerListener playerListener = new PlayerListener();
    private MinecraftServer server;
    private ModContainer modContainer;
    private MinecraftServerAudiences adventure;
    private boolean firstTick = true;
    private FabricNetwork network;

    public Pl3xMapFabricServer() {
        super(false);
    }

    public void onInitializeServer() {
        try {
            new FabricCommandManager();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.firstTick) {
                Pl3xMap.api().getEventRegistry().callEvent(new ServerLoadedEvent());
                this.firstTick = false;
            }
            this.getScheduler().tick();
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            Player fabricPlayer = this.getPlayerRegistry().getOrDefault(player.method_5667(), () -> new FabricPlayer(player));
            this.playerListener.onJoin(fabricPlayer);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            Player fabricPlayer = this.getPlayerRegistry().unregister(player.method_5667());
            if (fabricPlayer != null) {
                this.playerListener.onQuit(fabricPlayer);
            }
        });
        ServerWorldEvents.LOAD.register((server, level) -> {
            if (this.isEnabled()) {
                String name = level.method_27983().method_29177().toString();
                Pl3xMap.api().getWorldRegistry().getOrDefault(name, () -> new FabricWorld(level, name));
            }
        });
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            String name = level.method_27983().method_29177().toString();
            Pl3xMap.api().getWorldRegistry().unregister(name);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            this.adventure = MinecraftServerAudiences.of((MinecraftServer)this.server);
            this.enable();
            this.network = new FabricNetwork(this);
            this.network.register();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (this.network != null) {
                this.network.unregister();
                this.network = null;
            }
            this.disable();
            if (this.adventure != null) {
                this.adventure.close();
                this.adventure = null;
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> this.getPlayerRegistry().getOrDefault(newPlayer.method_5667(), () -> new FabricPlayer(newPlayer)).setPlayer(newPlayer));
    }

    public ModContainer getModContainer() {
        if (this.modContainer == null) {
            this.modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("pl3xmap").orElseThrow();
        }
        return this.modContainer;
    }

    @Override
    public String getPlatform() {
        return this.server.getServerModName().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getVersion() {
        return this.getModContainer().getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public int getMaxPlayers() {
        return this.server.method_3802();
    }

    @Override
    public boolean getOnlineMode() {
        return this.server.method_3828();
    }

    @Override
    public String getServerVersion() {
        return class_155.method_16673().comp_4025();
    }

    @Override
    public AudienceProvider adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return this.adventure;
    }

    @Override
    public Path getMainDir() {
        return FabricLoader.getInstance().getGameDir().resolve("config").resolve("pl3xmap");
    }

    @Override
    public Path getJarPath() {
        return (Path)this.getModContainer().getOrigin().getPaths().getFirst();
    }

    @Override
    public int getColorForPower(byte power) {
        return class_2457.method_10487((int)power);
    }

    @Override
    public @Nullable Block getFlower(World world, Biome biome, int blockX, int blockY, int blockZ) {
        class_1959 nms = (class_1959)((class_3218)world.getLevel()).method_30349().method_30530(class_7924.field_41236).method_63535(class_2960.method_60654((String)biome.getKey()));
        if (nms == null) {
            return null;
        }
        List flowers = nms.method_30970().method_30982();
        if (flowers.isEmpty()) {
            return null;
        }
        class_4638 config = (class_4638)((class_2975)flowers.getFirst()).comp_333();
        class_3175 flower = (class_3175)((class_2975)((class_6796)config.comp_155().comp_349()).comp_334().comp_349()).comp_333();
        class_2248 block = flower.comp_156().method_23455(this.randomSource, new class_2338(blockX, blockY, blockZ)).method_26204();
        return this.getBlockRegistry().get(class_7923.field_41175.method_10221((Object)block).toString());
    }

    @Override
    protected void loadBlocks() {
        Set entries = this.server.method_30611().method_30530(class_7924.field_41254).method_29722();
        for (Map.Entry entry : entries) {
            String id = ((class_5321)entry.getKey()).method_29177().toString();
            int color = ((class_2248)entry.getValue()).method_26403().field_16011;
            this.getBlockRegistry().register(id, color);
        }
        this.getBlockRegistry().saveToDisk();
    }

    @Override
    protected void loadWorlds() {
        this.server.method_3738().forEach(level -> {
            String name = level.method_27983().method_29177().toString();
            Pl3xMap.api().getWorldRegistry().getOrDefault(name, () -> new FabricWorld((class_3218)level, name));
        });
    }

    @Override
    protected void loadPlayers() {
        this.server.method_3760().method_14571().forEach(player -> {
            UUID uuid = player.method_5667();
            this.getPlayerRegistry().getOrDefault(uuid, () -> new FabricPlayer((class_3222)player));
        });
    }

    @Override
    public World cloneWorld(World world) {
        return new FabricWorld((class_3218)world.getLevel(), world.getName());
    }

    public @Nullable MinecraftServer getServer() {
        return this.server;
    }
}

