/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.incendo.cloud.permission.Permission;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
public final class OrPermission
implements Permission {
    private final Set<Permission> permissions;

    OrPermission(@NonNull Set<Permission> permissions) {
        if (permissions.isEmpty()) {
            throw new IllegalArgumentException("OrPermission may not have an empty set of permissions");
        }
        this.permissions = Collections.unmodifiableSet(permissions);
    }

    @Override
    public @NonNull Collection<@NonNull Permission> permissions() {
        return this.permissions;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public @NonNull String permissionString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Permission> iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            Permission permission = iterator.next();
            stringBuilder.append('(').append(permission.permissionString()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrPermission that = (OrPermission)o;
        return this.permissions.equals(that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.permissions());
    }

    public @NonNull String toString() {
        return this.permissionString();
    }
}

