/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.util;

import dev.tianmi.sussypatches.api.util.BoolSupplier;
import gregtech.api.util.Mods;
import java.util.function.Function;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.jetbrains.annotations.NotNull;

public enum SusMods implements BoolSupplier
{
    GCyM("gcym"),
    LoliASM("loliasm"),
    VintageFix("vintagefix"),
    FluidloggedAPI_2("fluidlogged_api", self -> self.version().startsWith("2")),
    FluidloggedAPI_3("fluidlogged_api", self -> self.version().startsWith("3"));

    private final String ID;
    private final Function<SusMods, Boolean> extraCheck;
    private Boolean loaded;

    private SusMods(String id) {
        this(id, null);
    }

    private SusMods(String id, Function<SusMods, Boolean> extraCheck) {
        this.ID = id;
        this.extraCheck = extraCheck;
    }

    public static BoolSupplier of(Mods mod) {
        return () -> ((Mods)mod).isModLoaded();
    }

    public String id() {
        return this.ID;
    }

    public boolean isLoaded() {
        if (this.loaded == null) {
            this.loaded = Loader.isModLoaded((String)this.ID);
            if (this.loaded.booleanValue() && this.extraCheck != null && !this.extraCheck.apply(this).booleanValue()) {
                this.loaded = false;
            }
        }
        return this.loaded;
    }

    @Override
    public boolean get() {
        return this.isLoaded();
    }

    @NotNull
    public String version() {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(this.ID);
        if (container == null) {
            return "";
        }
        return container.getVersion();
    }

    public static class Names {
        public static final String GCYM = "gcym";
        public static final String LOLIASM = "loliasm";
        public static final String VINTAGE_FIX = "vintagefix";
        public static final String FLUIDLOGGED_API = "fluidlogged_api";
    }
}

