/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common;

import net.minecraftforge.common.config.Config;

@Config(modid="sussypatches")
public class SusConfig {
    @Config.Comment(value={"Config options for additional features"})
    @Config.Name(value="Features")
    public static final Features FEAT = new Features();
    @Config.Comment(value={"Config options for external mod compat"})
    @Config.Name(value="Compatibilities")
    public static final Compat COMPAT = new Compat();
    @Config.Comment(value={"Config options for fixing GTCEu bugs"})
    @Config.Name(value="Bugfixes")
    public static final Bugfix BUGFIX = new Bugfix();

    public static final class Features {
        @Config.Comment(value={"Make ConnectedTexturesMod (CTM) work on GregTech multiblocks.", "Needs CTM to be loaded.", "Default: true"})
        @Config.Name(value="Connected textures for multiblocks")
        @Config.RequiresMcRestart
        public boolean CTM = true;
    }

    public static final class Compat {
        @Config.Comment(value={"Fixes GregTech machines lost their animations when \"On-Demand Animations\" is turned on in CensoredASM.", "Default: true"})
        @Config.Name(value="Fix on-demand animations")
        @Config.RequiresMcRestart
        public boolean FIX_ON_DEMAND = true;
        @Config.Comment(value={"Fixes GregTech's DummyWorld crashs with Alfheim v1.6+, which causes all GT recipes to disappear in JEI.", "Default: true"})
        @Config.Name(value="Fix Alfheim v1.6+ breaking JEI")
        @Config.RequiresMcRestart
        public boolean FIX_DUMMYWORLD = true;
        @Config.Comment(value={"Fixes some GT lamps losing their inventory models when both VintageFix and ConnectedTexturesMod are loaded.", "Default: true"})
        @Config.Name(value="Fix VintageFix making lamps invisible")
        @Config.RequiresMcRestart
        public boolean FIX_LAMP_MODEL = true;
        @Config.Comment(value={"Fixes Fluidlogged API v2 making multiblocks with fluid blocks in the structure failed to render the in-world preview.", "Fixed in Fluidlogged API v3.", "Default: true"})
        @Config.Name(value="Fix Fluidlogged API v2 render failure")
        @Config.RequiresMcRestart
        public boolean FIX_INWORLD_PREVIEW = true;
    }

    public static final class Bugfix {
        @Config.Comment(value={"Fixes clipboards always rendered at full brightness.", "Default: true"})
        @Config.Name(value="Fix clipboards lighting")
        @Config.RequiresMcRestart
        public boolean FIX_CLIPBOARD = true;
        @Config.Comment(value={"Fixes facades have weird lighting.", "A.k.a. different from normal blocks.", "Default: true"})
        @Config.Name(value="Fix facades lighting")
        @Config.RequiresMcRestart
        public boolean FIX_FACADE = true;
    }
}

