/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core;

import dev.tianmi.sussypatches.api.util.BoolSupplier;
import dev.tianmi.sussypatches.api.util.SusMods;
import dev.tianmi.sussypatches.common.SusConfig;
import gregtech.api.util.Mods;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LateMixinLoader
implements ILateMixinLoader {
    private static final Map<String, BoolSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BoolSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        return MIXIN_CONFIGS.get(mixinConfig).get();
    }

    static {
        Type.FEATURE.add("connectedtextures", SusConfig.FEAT.multiCTM, SusMods.of(Mods.CTM));
        Type.FEATURE.add("interactivestorage", SusConfig.FEAT.interactiveStorage);
        Type.FEATURE.add("fluidcontainerbar", SusConfig.FEAT.fluidContainerBar, SusConfig.API.itemOverlayEvent);
        Type.FEATURE.add("visiblestorage", SusConfig.FEAT.visibleStorage);
        Type.FEATURE.add("deepmaintenance", SusConfig.FEAT.deepMaintenance);
        Type.FEATURE.add("coverretainexact", SusConfig.FEAT.coverRetainExact);
        Type.COMPAT.add("ondemandanimation", SusConfig.COMPAT.fixOnDemandAnimation, SusMods.LoliASM, SusMods.OptiFine.negate());
        Type.COMPAT.add("dummyworldcrash", SusConfig.COMPAT.fixDummyWorld, SusMods.of(Mods.Alfheim));
        Type.COMPAT.add("lampbakedmodel", SusConfig.COMPAT.fixLampModel, SusMods.VintageFix, SusMods.of(Mods.CTM));
        Type.COMPAT.add("inworldpreviewcrash", SusConfig.COMPAT.fixInworldPreview, SusMods.FluidloggedAPI_2);
        Type.COMPAT.add("variousgrsissue", SusConfig.COMPAT.fixGrS, SusMods.of(Mods.GroovyScript), SusMods.NomiLibs.negate());
        Type.COMPAT.add("grsinlineicon", SusConfig.COMPAT.inlineIcon, SusMods.of(Mods.GroovyScript));
        Type.COMPAT.add("tweakerinfo", SusConfig.COMPAT.tweakerInfo, SusMods.of(Mods.GroovyScript).or(SusMods.of(Mods.CraftTweaker)), SusMods.of(Mods.JustEnoughItems));
        Type.COMPAT.add("nopipeforscanner", SusConfig.COMPAT.noPipeForScanner, SusMods.RFTools);
        Type.COMPAT.add("smartanimation", SusConfig.COMPAT.fixSmartAnimation, SusMods.OptiFine);
        Type.BUGFIX.add("clipboardlighting", SusConfig.BUGFIX.clipboardLighting);
        Type.BUGFIX.add("facadelighting", SusConfig.BUGFIX.facadeLighting);
        Type.BUGFIX.add("implgetitem", SusConfig.BUGFIX.implGetItem);
        Type.BUGFIX.add("packetdatamemleak", SusConfig.BUGFIX.packetMemLeak);
        Type.BUGFIX.add("pipedatatransfer", SusConfig.BUGFIX.pipeDataTransfer, SusMods.NomiLibs.negate());
        Type.BUGFIX.add("pipeinvcrash", SusConfig.BUGFIX.pipeInvCrash);
        Type.BUGFIX.add("invalidregistration", SusConfig.BUGFIX.invalidRegistration);
        Type.BUGFIX.add("weakneighborref", SusConfig.BUGFIX.weakNeighborRef);
        Type.BUGFIX.add("redundantgas", SusConfig.BUGFIX.redundantGas, SusMods.NomiLibs.negate());
        Type.BUGFIX.add("unbindframebuffer", SusConfig.BUGFIX.unbindFBO);
        Type.BUGFIX.add("dtguitext", SusConfig.BUGFIX.removeDTText);
        Type.BUGFIX.add("pipeframedesync", SusConfig.BUGFIX.pipeFrameDesync);
        Type.BUGFIX.add("mtenpeonserver", SusConfig.BUGFIX.mteServerNPE);
        Type.BUGFIX.add("relativedirection", SusConfig.BUGFIX.relativeDir);
        Type.BUGFIX.add("chunkaware", SusConfig.BUGFIX.chunkAware);
        Type.BUGFIX.add("cleanroomstructure", SusConfig.BUGFIX.cleanroomStruct, SusMods.NomiLibs.negate());
        Type.BUGFIX.add("previewmissingblocks", SusConfig.BUGFIX.previewMissingBlocks);
        Type.BUGFIX.add("workbenchvoidcontainers", SusConfig.BUGFIX.workbenchVoidContainers);
        Type.BUGFIX.add("thickpiperender", SusConfig.BUGFIX.thickPipeRender);
        Type.TWEAK.add("tabnosearchbars", SusConfig.TWEAK.noSearchBars);
        Type.TWEAK.add("xoshiro256plusplus", SusConfig.TWEAK.xoShiRo256plusplus);
        Type.TWEAK.add("previewoptimization", SusConfig.TWEAK.optPreview);
        Type.TWEAK.add("nomuffler", SusConfig.TWEAK.noMufflerRecovery, SusMods.NomiLibs.negate());
        Type.TWEAK.add("prospectorheight", SusConfig.TWEAK.prospectorHeight, SusMods.NomiLibs.negate());
        Type.TWEAK.add("thickercovers", SusConfig.TWEAK.thickerCovers);
        Type.TWEAK.add("activemteitems", SusConfig.TWEAK.activeMTEItems);
        Type.TWEAK.add("toolsubitems", SusConfig.TWEAK.showAllToolItems);
        Type.TWEAK.add("cstorageinf", !SusConfig.TWEAK.cStorageInf.isEmpty());
        Type.TWEAK.add("customsoundtype", SusConfig.TWEAK.customMTESounds);
        Type.TWEAK.add("mobspawnonstones", SusConfig.TWEAK.mobSpawnOnStones);
        Type.API.add("usemui2", SusConfig.API.useMui2, SusMods.ModularUI);
        Type.API.add("pipeicontypes", SusConfig.API.pipeIconTypes);
    }

    static enum Type {
        FEATURE,
        BUGFIX,
        TWEAK,
        COMPAT,
        API;

        private static final String ROOT = "sussypatches/";
        private static final String MIXINS = "mixins.";
        private static final String JSON = ".json";

        public String toString() {
            return this.name().toLowerCase() + "/";
        }

        public void add(String name, Object ... conditions) {
            MIXIN_CONFIGS.put(ROOT + (Object)((Object)this) + MIXINS + name + JSON, BoolSupplier.compact(conditions));
        }
    }
}

