/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.util;

import dev.tianmi.sussypatches.api.util.BoolSupplier;
import gregtech.api.util.Mods;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GLContext;

@ParametersAreNonnullByDefault
public enum SusMods implements BoolSupplier
{
    GCyM("gcym"),
    LoliASM("loliasm"),
    VintageFix("vintagefix"),
    Lwjgl3ify("lwjgl3ify"),
    ConfigAnytime("configanytime"),
    Cleanroom("cleanroom"),
    FluidloggedAPI_2("fluidlogged_api", self -> self.version().startsWith("2")),
    FluidloggedAPI_3("fluidlogged_api", self -> self.version().startsWith("3")),
    Celeritas("celeritas"),
    ModularUI("modularui"),
    NomiLibs("nomilabs"),
    RFTools("rftools"),
    OpenGL3(self -> GLContext.getCapabilities().OpenGL30),
    DevEnv(self -> FMLLaunchHandler.isDeobfuscatedEnvironment());

    @Nullable
    private final String ID;
    @Nullable
    private final Function<SusMods, Boolean> extraCheck;
    @Nullable
    private Boolean loaded;

    private SusMods(String id) {
        this(id, null);
    }

    private SusMods(Function<SusMods, Boolean> check) {
        this(null, check);
    }

    private SusMods(String id, Function<SusMods, Boolean> extraCheck) {
        this.ID = id;
        this.extraCheck = extraCheck;
    }

    public static BoolSupplier of(Mods mod) {
        return () -> ((Mods)mod).isModLoaded();
    }

    public boolean isLoaded() {
        if (this.loaded == null) {
            this.loaded = this.ID == null || Loader.isModLoaded((String)this.ID);
            if (this.loaded.booleanValue() && this.extraCheck != null && !this.extraCheck.apply(this).booleanValue()) {
                this.loaded = false;
            }
        }
        return this.loaded;
    }

    @Override
    public boolean get() {
        return this.isLoaded();
    }

    @NotNull
    public String version() {
        if (this.ID == null) {
            return "";
        }
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(this.ID);
        if (container == null) {
            return "";
        }
        return container.getVersion();
    }

    public static class Names {
        public static final String GCYM = "gcym";
        public static final String LOLIASM = "loliasm";
        public static final String VINTAGE_FIX = "vintagefix";
        public static final String LWJGL3IFY = "lwjgl3ify";
        public static final String CONFIGANYTIME = "configanytime";
        public static final String FLUIDLOGGED_API = "fluidlogged_api";
        public static final String CELERITAS = "celeritas";
        public static final String MODULARUI = "modularui";
        public static final String CLEANROOM = "cleanroom";
        public static final String NOMI_LIBS = "nomilabs";
        public static final String RFTOOLS = "rftools";
    }
}

