/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.client.renderer.textures.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import dev.tianmi.sussypatches.api.core.mixin.extension.CRSExtension;
import dev.tianmi.sussypatches.client.model.QuadWrapper;
import dev.tianmi.sussypatches.client.renderer.textures.ConnectedTextures;
import gregtech.api.block.VariantActiveBlock;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.ColourOperation;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.client.state.CTMExtendedState;

@ParametersAreNonnullByDefault
public class VisualStateRenderer
implements ICubeRenderer {
    protected final IBlockState visualState;
    protected final boolean isActive;
    protected TextureAtlasSprite particleSprite;

    public VisualStateRenderer(IBlockState visualState) {
        this(visualState, false);
    }

    public VisualStateRenderer(IBlockState visualState, boolean isActive) {
        this.visualState = visualState;
        this.isActive = isActive;
    }

    public static VisualStateRenderer from(IBlockState visualState) {
        return VisualStateRenderer.from(visualState, false);
    }

    public static VisualStateRenderer from(IBlockState visualState, boolean isActive) {
        return new VisualStateRenderer(visualState, isActive);
    }

    public IBlockState getVisualState() {
        return this.visualState;
    }

    public TextureAtlasSprite getParticleSprite() {
        if (this.particleSprite == null) {
            this.particleSprite = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.visualState).func_177554_e();
        }
        return this.particleSprite;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        CubeRendererState crs = (CubeRendererState)Textures.RENDER_STATE.get();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        Object[] renderPipeline = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{translation});
        IBlockState state = this.visualState;
        ArrayList quads = new ArrayList();
        if (crs == null || crs.layer == null) {
            IBakedModel model = brd.func_184389_a(state);
            if (this.isActive) {
                try {
                    state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)VariantActiveBlock.ACTIVE, (Object)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            quads.addAll(model.func_188616_a(state, null, 0L));
            for (EnumFacing facing : EnumFacing.values()) {
                quads.addAll(model.func_188616_a(state, facing, 0L));
            }
        } else {
            boolean emissive;
            BlockRenderLayer layer = crs.layer;
            if (!this.canRenderInLayer(layer)) {
                return;
            }
            IBlockAccess world = crs.world;
            BlockPos pos = CRSExtension.cast(crs).sus$getPos();
            try {
                state = state.func_185899_b(world, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IBakedModel model = brd.func_184389_a(state);
            try {
                state = state.func_177230_c().getExtendedState(state, world, pos);
            }
            catch (Exception facing) {
                // empty catch block
            }
            if (this.isActive) {
                try {
                    IExtendedBlockState extendedState = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)VariantActiveBlock.ACTIVE, (Object)true);
                    state = new CTMExtendedState((IBlockState)extendedState, world, pos);
                }
                catch (Exception extendedState) {
                    // empty catch block
                }
            }
            boolean bl = emissive = ConfigHolder.client.machinesEmissiveTextures && layer == BloomEffectUtil.getEffectiveBloomLayer();
            if (emissive) {
                renderPipeline = (IVertexOperation[])ArrayUtils.addAll((Object[])renderPipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), new ColourOperation(-1)});
            }
            long rand = MathHelper.func_180186_a((Vec3i)pos);
            quads.addAll(model.func_188616_a(state, null, rand));
            for (EnumFacing facing : EnumFacing.values()) {
                if (!crs.shouldSideBeRendered(facing, Cuboid6.full)) continue;
                quads.addAll(model.func_188616_a(state, facing, rand));
            }
        }
        for (BakedQuad quad : quads) {
            QuadWrapper quadWrapper = new QuadWrapper(quad);
            renderState.setPipeline((IVertexSource)quadWrapper, 0, quadWrapper.getVertices().length, (IVertexOperation[])renderPipeline);
            renderState.render();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing facing, boolean isActive, boolean isWorkingEnabled) {
        throw new UnsupportedOperationException("Call VisualStateRenderer#render(CCRenderState, Matrix4, IVertexOperation[]) instead!");
    }

    public void registerIcons(TextureMap textureMap) {
    }

    public boolean canRenderInLayer(@NotNull BlockRenderLayer layer) {
        return this.visualState.func_177230_c().canRenderInLayer(this.visualState, layer);
    }

    public void override(ResourceLocation ... mteIds) {
        for (ResourceLocation mteId : mteIds) {
            ConnectedTextures.REPLACEMENTS.put(mteId, any -> this);
        }
    }
}

