/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.event;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

@Cancelable
@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RenderItemOverlayEvent
extends Event {
    protected RenderOperation operation;

    public RenderItemOverlayEvent() {
        this.reset();
    }

    public void enqueue(RenderOperation operation) {
        this.operation = this.operation.andThen(operation);
    }

    public RenderOperation getOperation() {
        return this.operation;
    }

    public void reset() {
        this.operation = RenderOperation.EMPTY;
    }

    public boolean isCancelable() {
        return true;
    }

    @FunctionalInterface
    public static interface RenderOperation {
        public static final RenderOperation EMPTY = (stack, x, y, text) -> {};

        public void render(ItemStack var1, int var2, int var3, @Nullable String var4);

        default public boolean isEmpty() {
            return this == EMPTY;
        }

        default public RenderOperation andThen(RenderOperation other) {
            return (stack, x, y, text) -> {
                this.render(stack, x, y, text);
                other.render(stack, x, y, text);
            };
        }
    }
}

