/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import dev.tianmi.sussypatches.api.core.mixin.extension.ChunkAwareExtension;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkAwareHook {
    @SubscribeEvent
    public static void onChunkLoadUnload(ChunkEvent event) {
        boolean isLoad = event instanceof ChunkEvent.Load;
        boolean isUnLoad = event instanceof ChunkEvent.Unload;
        if (!isLoad && !isUnLoad) {
            return;
        }
        World world = event.getWorld();
        Chunk chunk = event.getChunk();
        int x = chunk.x;
        int z = chunk.z;
        IChunkProvider chunkProvider = world.getChunkProvider();
        for (EnumFacing side : EnumFacing.HORIZONTALS) {
            Chunk nearbyChunk = chunkProvider.getLoadedChunk(x + side.getXOffset(), z + side.getZOffset());
            if (nearbyChunk == null || !nearbyChunk.isLoaded()) continue;
            nearbyChunk.getTileEntityMap().forEach((pos, tile) -> {
                if (tile instanceof ChunkAwareExtension) {
                    ChunkAwareExtension chunkAware = (ChunkAwareExtension)tile;
                    if (ChunkAwareHook.isNextToChunkAtSide(pos, x, z, side)) {
                        if (isLoad) {
                            chunkAware.onNeighborChunkLoad(side.getOpposite());
                        }
                        if (isUnLoad) {
                            chunkAware.onNeighborChunkUnload(side.getOpposite());
                        }
                    }
                }
            });
        }
    }

    private static boolean isNextToChunkAtSide(BlockPos pos, int chunkX, int chunkZ, EnumFacing side) {
        boolean bl;
        int minX = chunkX * 16;
        int minZ = chunkZ * 16;
        switch (side) {
            case EAST: {
                if (pos.getX() - minX == -1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                if (pos.getX() - minX == 16) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NORTH: {
                if (pos.getZ() - minZ == -1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                if (pos.getZ() - minZ == 16) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

