/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core.mixin.bugfix.weakneighborref;

import dev.tianmi.sussypatches.api.core.mixin.extension.NeighborCacheExtension;
import gregtech.api.metatileentity.NeighborCacheTileEntityBase;
import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.metatileentity.interfaces.INeighborCache;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NeighborCacheTileEntityBase.class}, remap=false)
public abstract class NeighborCacheTileEntityBaseMixin
extends SyncedTileEntityBase
implements NeighborCacheExtension,
INeighborCache {
    @Mutable
    @Final
    @Shadow
    private TileEntity[] neighbors;
    @Shadow
    private boolean neighborsInvalidated;
    @Unique
    private final List<WeakReference<TileEntity>> sus$neighbors = Arrays.asList(INVALID, INVALID, INVALID, INVALID, INVALID, INVALID);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void clearOriginalImpl(CallbackInfo ci) {
        this.neighbors = null;
    }

    @Redirect(method={"invalidateNeighbors"}, at=@At(value="INVOKE", target="Ljava/util/Arrays;fill([Ljava/lang/Object;Ljava/lang/Object;)V"))
    private void invalidateWeakRefs(Object[] _null, Object _this) {
        for (EnumFacing facing : EnumFacing.values()) {
            this.sus$neighbors.set(facing.getIndex(), INVALID);
        }
    }

    @Overwrite
    @Nullable
    public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        if (this.world == null || this.pos == null) {
            return null;
        }
        WeakReference<TileEntity> ref = this.sus$invalidRef(facing) ? this.sus$computeNeighbor(facing) : this.sus$getRef(facing);
        return (TileEntity)ref.get();
    }

    @Overwrite
    public void onNeighborChanged(@NotNull EnumFacing facing) {
        this.sus$neighbors.set(facing.getIndex(), INVALID);
    }

    @Override
    @Unique
    @NotNull
    public WeakReference<TileEntity> sus$computeNeighbor(EnumFacing facing) {
        TileEntity te = super.getNeighbor(facing);
        WeakReference<Object> ref = te == null ? NULL : new WeakReference<TileEntity>(te);
        this.sus$neighbors.set(facing.getIndex(), (WeakReference<TileEntity>)ref);
        this.neighborsInvalidated = false;
        return ref;
    }

    @Override
    @Unique
    @NotNull
    public WeakReference<TileEntity> sus$getRef(EnumFacing facing) {
        return this.sus$neighbors.get(facing.getIndex());
    }

    @Override
    @Unique
    public boolean sus$invalidRef(EnumFacing facing) {
        WeakReference<TileEntity> ref = this.sus$getRef(facing);
        if (ref == INVALID) {
            return true;
        }
        TileEntity te = (TileEntity)ref.get();
        return te != null && te.isInvalid();
    }
}

