/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.util;

import dev.tianmi.sussypatches.api.util.SusMods;
import gregtech.client.utils.BloomEffectUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class OptiFineHelper {
    private static final MethodHandle BUFFER_SPRITE_SETTER = OptiFineHelper.initSpriteSetter();

    private static MethodHandle initSpriteSetter() {
        if (SusMods.OptiFine.isLoaded()) {
            return MethodHandles.lookup().findVirtual(BufferBuilder.class, "setSprite", MethodType.methodType(Void.TYPE, TextureAtlasSprite.class));
        }
        return null;
    }

    public static BlockRenderLayer getOFSafeLayer(BlockRenderLayer layer) {
        if (!SusMods.ShadersMod.isLoaded()) {
            return layer;
        }
        return layer == BloomEffectUtil.getBloomLayer() ? BloomEffectUtil.getEffectiveBloomLayer() : layer;
    }

    public static void preRenderChunkLayer(BlockRenderLayer layer) {
        if (SusMods.ShadersMod.isLoaded()) {
            ShadersRender.preRenderChunkLayer((BlockRenderLayer)OptiFineHelper.getOFSafeLayer(layer));
        }
    }

    public static void postRenderChunkLayer(BlockRenderLayer layer) {
        if (SusMods.ShadersMod.isLoaded()) {
            ShadersRender.postRenderChunkLayer((BlockRenderLayer)OptiFineHelper.getOFSafeLayer(layer));
        }
    }

    public static void setSprite(BufferBuilder buffer, TextureAtlasSprite sprite) {
        BUFFER_SPRITE_SETTER.invokeExact(buffer, sprite);
    }

    public static boolean isShaderActive() {
        return SusMods.OptiFine.isLoaded() && Shaders.shaderPackLoaded;
    }

    @Generated
    private OptiFineHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

