/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.client.model;

import codechicken.lib.lighting.LC;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.consumer.UnpackingVertexConsumer;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.SideAttribute;
import codechicken.lib.vec.Vertex5;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadWrapper
implements IVertexSource {
    public final TextureAtlasSprite sprite;
    public Vertex5[] vertices = new Vertex5[4];
    public LC[] lightCoords = new LC[4];
    public int side;

    public QuadWrapper(BakedQuad quad) {
        VertexFormat format = quad.getFormat();
        this.side = quad.func_178210_d().func_176745_a();
        this.sprite = quad.func_187508_a();
        UnpackingVertexConsumer consumer = new UnpackingVertexConsumer(quad.getFormat());
        quad.pipe((IVertexConsumer)consumer);
        float[][][] unpackedData = consumer.getUnpackedData();
        for (int v = 0; v < 4; ++v) {
            this.vertices[v] = new Vertex5();
            this.lightCoords[v] = new LC();
            block5: for (int e = 0; e < format.func_177345_h(); ++e) {
                float[] data = unpackedData[v][e];
                switch (format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        this.vertices[v].vec.set(data);
                        continue block5;
                    }
                    case UV: {
                        if (format.func_177348_c(e).func_177369_e() != 0) continue block5;
                        this.vertices[v].uv.set((double)data[0], (double)data[1]);
                        continue block5;
                    }
                }
            }
            this.lightCoords[v].compute(this.vertices[v].vec, this.side);
        }
    }

    public Vertex5[] getVertices() {
        return this.vertices;
    }

    public <T> T getAttributes(AttributeKey<T> attr) {
        return (T)(LightCoordAttribute.attributeKey.equals(attr) ? this.lightCoords : null);
    }

    public boolean hasAttribute(AttributeKey<?> attr) {
        return SideAttribute.attributeKey.equals(attr) || LightCoordAttribute.attributeKey.equals(attr);
    }

    public void prepareVertex(CCRenderState state) {
        state.side = this.side;
    }
}

