/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.mui2.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PosGuiData;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MTEGuiFactory
extends AbstractUIFactory<PosGuiData> {
    public static final MTEGuiFactory INSTANCE = new MTEGuiFactory();

    private MTEGuiFactory() {
        super("gregtech:mte");
    }

    public static <T extends MetaTileEntity> void open(EntityPlayer player, T mte) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(mte);
        if (!mte.isValid()) {
            throw new IllegalArgumentException("Can't open invalid MetaTileEntity GUI!");
        }
        if (player.field_70170_p != mte.getWorld()) {
            throw new IllegalArgumentException("MetaTileEntity must be in same dimension as the player!");
        }
        BlockPos pos = mte.getPos();
        PosGuiData data = new PosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        GuiManager.open((UIFactory)INSTANCE, (GuiData)data, (EntityPlayerMP)MTEGuiFactory.verifyServerSide((EntityPlayer)player));
    }

    @NotNull
    public IGuiHolder<PosGuiData> getGuiHolder(PosGuiData data) {
        TileEntity te = data.getTileEntity();
        if (te instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtte = (IGregTechTileEntity)te;
            MetaTileEntity mte = gtte.getMetaTileEntity();
            return Objects.requireNonNull(this.castGuiHolder(mte), "Found MetaTileEntity is not a gui holder!");
        }
        throw new IllegalStateException("Found TileEntity is not a MetaTileEntity!");
    }

    public void writeGuiData(PosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
    }

    @NotNull
    public PosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }
}

