/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.client.renderer.scene;

import dev.tianmi.sussypatches.api.core.mixin.extension.WSRExtension;
import dev.tianmi.sussypatches.api.util.OptiFineHelper;
import dev.tianmi.sussypatches.api.util.RenderPass;
import dev.tianmi.sussypatches.api.util.SusMods;
import dev.tianmi.sussypatches.client.renderer.buffer.VertexArrayObject;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.scene.ISceneRenderHook;
import gregtech.client.renderer.scene.ImmediateWorldSceneRenderer;
import gregtech.client.renderer.scene.WorldSceneRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.ShadersRender;

@SideOnly(value=Side.CLIENT)
public class VBOWorldSceneRenderer
extends ImmediateWorldSceneRenderer {
    protected static final VertexArrayObject[] VAOS = new VertexArrayObject[BlockRenderLayer.values().length];
    protected static final VertexBuffer[] VBOS = new VertexBuffer[BlockRenderLayer.values().length];
    protected static final Map<BlockPos, TileEntity> TILE_ENTITIES = new Object2ObjectArrayMap();
    protected boolean isDirty = true;

    public VBOWorldSceneRenderer(World world) {
        super(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadVBO() {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
                VBOWorldSceneRenderer.setDefaultPassRenderState((int)pass);
                OptiFineHelper.preRenderChunkLayer(layer);
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                BlockRendererDispatcher brd = mc.func_175602_ab();
                Collection<BlockPos> renderedBlocks = WSRExtension.cast((WorldSceneRenderer)this).sus$getRenderedBlocks();
                for (BlockPos pos : renderedBlocks) {
                    IBlockState state = this.world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a || !block.canRenderInLayer(state = state.func_185899_b((IBlockAccess)this.world, pos), layer)) continue;
                    brd.func_175018_a(state, pos, (IBlockAccess)this.world, buffer);
                }
                buffer.func_178977_d();
                buffer.func_178965_a();
                int i = layer.ordinal();
                VertexBuffer vbo = VBOS[i];
                if (vbo == null) {
                    vbo = VBOWorldSceneRenderer.VBOS[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                }
                vbo.func_181722_a(buffer.func_178966_f());
                if (SusMods.OpenGL3.isLoaded()) {
                    VertexArrayObject vao = VAOS[i];
                    if (vao == null) {
                        vao = VBOWorldSceneRenderer.VAOS[i] = new VertexArrayObject();
                    }
                    vao.bindVertexArray();
                    vbo.func_177359_a();
                    this.enableClientStates();
                    this.setupArrayPointers();
                    vao.unbindVertexArray();
                    this.disableClientStates();
                    vbo.func_177361_b();
                }
                OptiFineHelper.postRenderChunkLayer(layer);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        this.isDirty = false;
    }

    protected void drawWorld() {
        if (this.isDirty) {
            this.uploadVBO();
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            RenderPass pass = layer == BlockRenderLayer.TRANSLUCENT ? RenderPass.TRANSLUCENT : RenderPass.NORMAL;
            VBOWorldSceneRenderer.setPassRenderState(pass);
            OptiFineHelper.preRenderChunkLayer(layer);
            GlStateManager.func_179094_E();
            int i = layer.ordinal();
            VertexBuffer vbo = VBOS[i];
            int preVBO = GlStateManager.func_187397_v((int)34964);
            vbo.func_177359_a();
            if (SusMods.OpenGL3.isLoaded()) {
                VertexArrayObject vao = VAOS[i];
                vao.bindVertexArray();
                vbo.func_177358_a(7);
                vao.unbindVertexArray();
            } else {
                this.enableClientStates();
                this.setupArrayPointers();
                vbo.func_177358_a(7);
                this.disableClientStates();
            }
            vbo.func_177361_b();
            OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)preVBO);
            GlStateManager.func_179121_F();
            OptiFineHelper.postRenderChunkLayer(layer);
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        this.renderTileEntities();
        GlStateManager.func_179103_j((int)7425);
        RenderHelper.func_74519_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPos> blocks, ISceneRenderHook _null) {
        this.isDirty = true;
        super.addRenderedBlocks(blocks, _null);
        TILE_ENTITIES.clear();
        blocks.forEach(pos -> {
            IGregTechTileEntity gtte;
            TileEntity tile = this.world.func_175625_s(pos);
            if (tile != null && (!(tile instanceof IGregTechTileEntity) || (gtte = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof IFastRenderMetaTileEntity)) {
                TILE_ENTITIES.put((BlockPos)pos, tile);
            }
        });
        return this;
    }

    protected void enableClientStates() {
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
    }

    protected void disableClientStates() {
        for (VertexFormatElement element : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            switch (element.func_177375_c()) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + element.func_177369_e()));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
            }
        }
    }

    protected void setupArrayPointers() {
        if (SusMods.ShadersMod.isLoaded()) {
            ShadersRender.setupArrayPointersVbo();
        } else {
            GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
    }

    protected void renderTileEntities() {
        RenderHelper.func_74519_b();
        TileEntityRendererDispatcher terd = TileEntityRendererDispatcher.field_147556_a;
        for (RenderPass pass : RenderPass.values()) {
            ForgeHooksClient.setRenderPass((int)pass.ordinal());
            VBOWorldSceneRenderer.setPassRenderState(pass);
            TILE_ENTITIES.forEach((pos, tile) -> {
                if (tile.shouldRenderInPass(pass.ordinal())) {
                    terd.func_147549_a(tile, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
                }
            });
        }
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
    }

    public static void setPassRenderState(RenderPass pass) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass.isTranslucent()) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179103_j((int)7424);
        }
    }
}

