/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.client.renderer.textures;

import dev.tianmi.sussypatches.client.renderer.textures.cube.VisualStateRenderer;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.api.utils.GCYMUtil;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.capability.IObjectHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ConnectedTextures {
    public static final Set<ICubeRenderer> NONE_OVERLAYS = new ObjectOpenHashSet();
    public static final Map<ResourceLocation, Function<@Nullable IMultiblockPart, @Nullable ICubeRenderer>> REPLACEMENTS = new Object2ObjectArrayMap();
    public static final VisualStateRenderer PRIMITIVE_BRICKS_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS));
    public static final VisualStateRenderer HEAT_PROOF_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF));
    public static final VisualStateRenderer FROST_PROOF_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF));
    public static final VisualStateRenderer SOLID_STEEL_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID));
    public static final VisualStateRenderer VOLTAGE_CASING_ULV_CTM = VisualStateRenderer.from(MetaBlocks.MACHINE_CASING.getState((Enum)BlockMachineCasing.MachineCasingType.ULV));
    public static final VisualStateRenderer CLEAN_STAINLESS_STEEL_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN));
    public static final VisualStateRenderer STABLE_TITANIUM_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.TITANIUM_STABLE));
    public static final VisualStateRenderer ROBUST_TUNGSTENSTEEL_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST));
    public static final VisualStateRenderer STEEL_TURBINE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING));
    public static final VisualStateRenderer STAINLESS_TURBINE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING));
    public static final VisualStateRenderer TITANIUM_TURBINE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.TITANIUM_TURBINE_CASING));
    public static final VisualStateRenderer TUNGSTENSTEEL_TURBINE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING));
    public static final VisualStateRenderer BRONZE_PLATED_BRICKS_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.BRONZE_BRICKS));
    public static final VisualStateRenderer BRONZE_FIREBOX_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.BRONZE_FIREBOX));
    public static final VisualStateRenderer BRONZE_FIREBOX_ACTIVE_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.BRONZE_FIREBOX));
    public static final VisualStateRenderer STEEL_FIREBOX_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX));
    public static final VisualStateRenderer STEEL_FIREBOX_ACTIVE_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX));
    public static final VisualStateRenderer TITANIUM_FIREBOX_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.TITANIUM_FIREBOX));
    public static final VisualStateRenderer TITANIUM_FIREBOX_ACTIVE_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.TITANIUM_FIREBOX));
    public static final VisualStateRenderer TUNGSTENSTEEL_FIREBOX_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX));
    public static final VisualStateRenderer TUNGSTENSTEEL_FIREBOX_ACTIVE_CTM = VisualStateRenderer.from(MetaBlocks.BOILER_FIREBOX_CASING.getState((Enum)BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX));
    public static final VisualStateRenderer COKE_BRICKS_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.COKE_BRICKS));
    public static final VisualStateRenderer GRATE_CASING_STEEL_FRONT_CTM = VisualStateRenderer.from(MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING));
    public static final VisualStateRenderer INERT_PTFE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PTFE_INERT_CASING));
    public static final VisualStateRenderer STURDY_HSSE_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.HSSE_STURDY));
    public static final VisualStateRenderer PLASCRETE_CTM = VisualStateRenderer.from(MetaBlocks.CLEANROOM_CASING.getState((Enum)BlockCleanroomCasing.CasingType.PLASCRETE));
    public static final VisualStateRenderer COMPUTER_CASING_CTM = VisualStateRenderer.from(MetaBlocks.COMPUTER_CASING.getState((Enum)BlockComputerCasing.CasingType.COMPUTER_CASING));
    public static final VisualStateRenderer HIGH_POWER_CASING_CTM = VisualStateRenderer.from(MetaBlocks.COMPUTER_CASING.getState((Enum)BlockComputerCasing.CasingType.HIGH_POWER_CASING));
    public static final VisualStateRenderer ADVANCED_COMPUTER_CASING_CTM = VisualStateRenderer.from(MetaBlocks.COMPUTER_CASING.getState((Enum)BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING));
    public static final VisualStateRenderer PALLADIUM_SUBSTATION_CASING_CTM = VisualStateRenderer.from(MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION));
    public static final VisualStateRenderer WOOD_WALL_CTM = VisualStateRenderer.from(MetaBlocks.STEAM_CASING.getState((Enum)BlockSteamCasing.SteamCasingType.WOOD_WALL));
    public static final VisualStateRenderer PRIMITIVE_PUMP_CTM = VisualStateRenderer.from(MetaBlocks.STEAM_CASING.getState((Enum)BlockSteamCasing.SteamCasingType.PUMP_DECK));
    public static final VisualStateRenderer MACERATOR_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.MACERATOR_CASING));
    public static final VisualStateRenderer BLAST_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.HIGH_TEMPERATURE_CASING));
    public static final VisualStateRenderer ASSEMBLING_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.ASSEMBLING_CASING));
    public static final VisualStateRenderer STRESS_PROOF_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.STRESS_PROOF_CASING));
    public static final VisualStateRenderer CORROSION_PROOF_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.CORROSION_PROOF_CASING));
    public static final VisualStateRenderer VIBRATION_SAFE_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.VIBRATION_SAFE_CASING));
    public static final VisualStateRenderer WATERTIGHT_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.WATERTIGHT_CASING));
    public static final VisualStateRenderer CUTTER_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.CUTTER_CASING));
    public static final VisualStateRenderer NONCONDUCTING_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.NONCONDUCTING_CASING));
    public static final VisualStateRenderer MIXER_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.MIXER_CASING));
    public static final VisualStateRenderer ENGRAVER_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.ENGRAVER_CASING));
    public static final VisualStateRenderer ATOMIC_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.ATOMIC_CASING));
    public static final VisualStateRenderer STEAM_CASING_CTM = VisualStateRenderer.from(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.STEAM_CASING));

    @Nullable
    public static ICubeRenderer get(ResourceLocation id, @Nullable IMultiblockPart part) {
        Function<IMultiblockPart, ICubeRenderer> function = REPLACEMENTS.get(id);
        if (function == null) {
            return null;
        }
        return function.apply(part);
    }

    public static void registerCustomOverride(ResourceLocation id, Function<@Nullable IMultiblockPart, @Nullable ICubeRenderer> function) {
        REPLACEMENTS.put(id, function);
    }

    public static boolean shouldOffset(ICubeRenderer overlay) {
        return !NONE_OVERLAYS.contains(overlay);
    }

    private static ICubeRenderer fromBoilerPart(@Nullable IMultiblockPart part, ICubeRenderer casing, ICubeRenderer firebox, ICubeRenderer fireboxActive) {
        IMultiblockAbilityPart ability;
        if (part instanceof IMultiblockAbilityPart && (ability = (IMultiblockAbilityPart)part).getAbility() == MultiblockAbility.EXPORT_FLUIDS) {
            return casing;
        }
        if (part instanceof MetaTileEntityMultiblockPart) {
            MetaTileEntityMultiblockPart actualPart = (MetaTileEntityMultiblockPart)part;
            return actualPart.getController().isActive() ? fireboxActive : firebox;
        }
        return casing;
    }

    public static void init() {
        ConnectedTextures.registerNonOverlays();
        ConnectedTextures.registerCTMOverrides();
    }

    public static void registerNonOverlays() {
        NONE_OVERLAYS.addAll(Arrays.asList(Textures.BRONZE_PLATED_BRICKS, Textures.PRIMITIVE_BRICKS, Textures.COKE_BRICKS, Textures.HEAT_PROOF_CASING, Textures.FROST_PROOF_CASING, Textures.SOLID_STEEL_CASING, Textures.CLEAN_STAINLESS_STEEL_CASING, Textures.STABLE_TITANIUM_CASING, Textures.ROBUST_TUNGSTENSTEEL_CASING, Textures.STURDY_HSSE_CASING, Textures.PALLADIUM_SUBSTATION_CASING, Textures.INERT_PTFE_CASING, Textures.PLASCRETE, Textures.FUSION_TEXTURE, Textures.ACTIVE_FUSION_TEXTURE, Textures.GRATE_CASING, Textures.HIGH_POWER_CASING));
        NONE_OVERLAYS.addAll(Arrays.asList(GCYMTextures.MACERATOR_CASING, GCYMTextures.BLAST_CASING, GCYMTextures.ASSEMBLING_CASING, GCYMTextures.STRESS_PROOF_CASING, GCYMTextures.CORROSION_PROOF_CASING, GCYMTextures.VIBRATION_SAFE_CASING, GCYMTextures.WATERTIGHT_CASING, GCYMTextures.CUTTER_CASING, GCYMTextures.NONCONDUCTING_CASING, GCYMTextures.MIXER_CASING, GCYMTextures.ENGRAVER_CASING, GCYMTextures.ATOMIC_CASING, GCYMTextures.STEAM_CASING));
    }

    public static void registerCTMOverrides() {
        PRIMITIVE_BRICKS_CTM.override(GTUtility.gregtechId((String)"primitive_blast_furnace.bronze"));
        HEAT_PROOF_CASING_CTM.override(GTUtility.gregtechId((String)"electric_blast_furnace"), GTUtility.gregtechId((String)"multi_furnace"));
        FROST_PROOF_CASING_CTM.override(GTUtility.gregtechId((String)"vacuum_freezer"));
        SOLID_STEEL_CASING_CTM.override(GTUtility.gregtechId((String)"implosion_compressor"), GTUtility.gregtechId((String)"large_miner.ev"), GTUtility.gregtechId((String)"central_monitor"), GTUtility.gregtechId((String)"fluid_drilling_rig.mv"), GTUtility.gregtechId((String)"tank.steel"));
        VOLTAGE_CASING_ULV_CTM.override(GTUtility.gregtechId((String)"pyrolyse_oven"));
        CLEAN_STAINLESS_STEEL_CASING_CTM.override(GTUtility.gregtechId((String)"distillation_tower"), GTUtility.gregtechId((String)"cracker"));
        STABLE_TITANIUM_CASING_CTM.override(GTUtility.gregtechId((String)"large_combustion_engine"), GTUtility.gregtechId((String)"large_miner.iv"), GTUtility.gregtechId((String)"fluid_drilling_rig.hv"));
        ROBUST_TUNGSTENSTEEL_CASING_CTM.override(GTUtility.gregtechId((String)"extreme_combustion_engine"), GTUtility.gregtechId((String)"large_miner.luv"), GTUtility.gregtechId((String)"processing_array"), GTUtility.gregtechId((String)"fluid_drilling_rig.ev"));
        STEEL_TURBINE_CASING_CTM.override(GTUtility.gregtechId((String)"large_turbine.steam"));
        STAINLESS_TURBINE_CASING_CTM.override(GTUtility.gregtechId((String)"large_turbine.gas"));
        TUNGSTENSTEEL_TURBINE_CASING_CTM.override(GTUtility.gregtechId((String)"large_turbine.plasma"));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"large_boiler.bronze"), part -> ConnectedTextures.fromBoilerPart(part, BRONZE_PLATED_BRICKS_CTM, BRONZE_FIREBOX_CTM, BRONZE_FIREBOX_ACTIVE_CTM));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"large_boiler.steel"), part -> ConnectedTextures.fromBoilerPart(part, SOLID_STEEL_CASING_CTM, STEEL_FIREBOX_CTM, STEEL_FIREBOX_ACTIVE_CTM));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"large_boiler.titanium"), part -> ConnectedTextures.fromBoilerPart(part, STABLE_TITANIUM_CASING_CTM, TITANIUM_FIREBOX_CTM, TITANIUM_FIREBOX_ACTIVE_CTM));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"large_boiler.tungstensteel"), part -> ConnectedTextures.fromBoilerPart(part, ROBUST_TUNGSTENSTEEL_CASING_CTM, TUNGSTENSTEEL_FIREBOX_CTM, TUNGSTENSTEEL_FIREBOX_ACTIVE_CTM));
        COKE_BRICKS_CTM.override(GTUtility.gregtechId((String)"coke_oven"));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"assembly_line"), part -> part == null || part instanceof IDataAccessHatch ? GRATE_CASING_STEEL_FRONT_CTM : SOLID_STEEL_CASING_CTM);
        INERT_PTFE_CASING_CTM.override(GTUtility.gregtechId((String)"large_chemical_reactor"));
        boolean useSteel = ConfigHolder.machines.steelSteamMultiblocks;
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"steam_oven"), part -> {
            IMultiblockAbilityPart abilityPart;
            if (part instanceof IMultiblockAbilityPart && (abilityPart = (IMultiblockAbilityPart)part).getAbility() == MultiblockAbility.STEAM && part instanceof MetaTileEntityMultiblockPart) {
                MetaTileEntityMultiblockPart actualPart = (MetaTileEntityMultiblockPart)part;
                boolean active = actualPart.getController().isActive();
                if (useSteel) {
                    return active ? STEEL_FIREBOX_ACTIVE_CTM : STEEL_FIREBOX_CTM;
                }
                return active ? BRONZE_FIREBOX_ACTIVE_CTM : BRONZE_FIREBOX_CTM;
            }
            return useSteel ? SOLID_STEEL_CASING_CTM : BRONZE_PLATED_BRICKS_CTM;
        });
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"steam_grinder"), part -> useSteel ? SOLID_STEEL_CASING_CTM : BRONZE_PLATED_BRICKS_CTM);
        STURDY_HSSE_CASING_CTM.override(GTUtility.gregtechId((String)"advanced_processing_array"));
        PLASCRETE_CTM.override(GTUtility.gregtechId((String)"cleanroom"));
        BRONZE_PLATED_BRICKS_CTM.override(GTUtility.gregtechId((String)"charcoal_pile"));
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"data_bank"), part -> part instanceof IDataAccessHatch ? COMPUTER_CASING_CTM : HIGH_POWER_CASING_CTM);
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"research_station"), part -> part == null || part instanceof IObjectHolder ? ADVANCED_COMPUTER_CASING_CTM : COMPUTER_CASING_CTM);
        ConnectedTextures.registerCustomOverride(GTUtility.gregtechId((String)"high_performance_computing_array"), part -> part == null ? ADVANCED_COMPUTER_CASING_CTM : COMPUTER_CASING_CTM);
        COMPUTER_CASING_CTM.override(GTUtility.gregtechId((String)"network_switch"));
        PALLADIUM_SUBSTATION_CASING_CTM.override(GTUtility.gregtechId((String)"power_substation"));
        HIGH_POWER_CASING_CTM.override(GTUtility.gregtechId((String)"active_transformer"));
        WOOD_WALL_CTM.override(GTUtility.gregtechId((String)"tank.wood"));
        PRIMITIVE_PUMP_CTM.override(GTUtility.gregtechId((String)"primitive_water_pump"));
        MACERATOR_CASING_CTM.override(GCYMUtil.gcymId((String)"large_macerator"));
        BLAST_CASING_CTM.override(GCYMUtil.gcymId((String)"alloy_blast_smelter"), GCYMUtil.gcymId((String)"alloy_blast_smelter"));
        ASSEMBLING_CASING_CTM.override(GCYMUtil.gcymId((String)"large_assembler"), GCYMUtil.gcymId((String)"large_circuit_assembler"));
        WATERTIGHT_CASING_CTM.override(GCYMUtil.gcymId((String)"large_autoclave"), GCYMUtil.gcymId((String)"large_chemical_bath"), GCYMUtil.gcymId((String)"large_extractor"), GCYMUtil.gcymId((String)"large_distillery"), GCYMUtil.gcymId((String)"large_solidifier"));
        STRESS_PROOF_CTM.override(GCYMUtil.gcymId((String)"large_bender"), GCYMUtil.gcymId((String)"large_extruder"), GCYMUtil.gcymId((String)"large_wiremill"));
        CORROSION_PROOF_CASING_CTM.override(GCYMUtil.gcymId((String)"large_brewer"));
        VIBRATION_SAFE_CASING_CTM.override(GCYMUtil.gcymId((String)"large_centrifuge"), GCYMUtil.gcymId((String)"large_sifter"));
        CUTTER_CASING_CTM.override(GCYMUtil.gcymId((String)"large_cutter"));
        NONCONDUCTING_CASING_CTM.override(GCYMUtil.gcymId((String)"large_electrolyzer"), GCYMUtil.gcymId((String)"large_polarizer"));
        MIXER_CASING_CTM.override(GCYMUtil.gcymId((String)"large_mixer"));
        SOLID_STEEL_CASING_CTM.override(GCYMUtil.gcymId((String)"large_packager"));
        ENGRAVER_CASING_CTM.override(GCYMUtil.gcymId((String)"large_engraver"));
        ROBUST_TUNGSTENSTEEL_CASING_CTM.override(GCYMUtil.gcymId((String)"electric_implosion_compressor"));
        ConnectedTextures.registerCustomOverride(GCYMUtil.gcymId((String)"mega_blast_furnace"), part -> part instanceof IMufflerHatch ? ROBUST_TUNGSTENSTEEL_CASING_CTM : BLAST_CASING_CTM);
        FROST_PROOF_CASING_CTM.override(GCYMUtil.gcymId((String)"mega_vacuum_freezer"));
        STEAM_CASING_CTM.override(GCYMUtil.gcymId((String)"steam_engine"));
    }
}

