/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core.mixin.tweak.customsoundtype;

import dev.tianmi.sussypatches.api.core.mixin.extension.SoundTypeExtension;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.common.metatileentities.MetaTileEntityClipboard;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOven;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOvenHatch;
import gregtech.common.metatileentities.multi.MetaTileEntityMultiblockTank;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveWaterPump;
import gregtech.common.metatileentities.multi.MetaTileEntityPumpHatch;
import gregtech.common.metatileentities.multi.MetaTileEntityTankValve;
import gregtech.common.metatileentities.storage.MetaTileEntityCrate;
import gregtech.common.metatileentities.storage.MetaTileEntityDrum;
import gregtech.common.metatileentities.storage.MetaTileEntityWorkbench;
import net.minecraft.block.SoundType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MetaTileEntity.class}, remap=false)
public abstract class MTEsMixin
implements SoundTypeExtension {

    @Mixin(value={MetaTileEntityDrum.class}, remap=false)
    private static abstract class DrumMixin
    extends MTEsMixin {
        @Shadow
        @Final
        private boolean isWood;

        private DrumMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return this.isWood ? SoundType.WOOD : SoundType.METAL;
        }
    }

    @Mixin(value={MetaTileEntityCrate.class}, remap=false)
    private static abstract class CrateMixin
    extends MTEsMixin {
        @Shadow
        @Final
        private Material material;

        private CrateMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return ModHandler.isMaterialWood((Material)this.material) ? SoundType.WOOD : SoundType.METAL;
        }
    }

    @Mixin(value={MetaTileEntityTankValve.class}, remap=false)
    private static abstract class TankValveMixin
    extends MTEsMixin {
        @Shadow
        @Final
        private boolean isMetal;

        private TankValveMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return this.isMetal ? SoundType.METAL : SoundType.WOOD;
        }
    }

    @Mixin(value={MetaTileEntityMultiblockTank.class}, remap=false)
    private static abstract class MultiblockTankMixin
    extends MTEsMixin {
        @Shadow
        @Final
        private boolean isMetal;

        private MultiblockTankMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return this.isMetal ? SoundType.METAL : SoundType.WOOD;
        }
    }

    @Mixin(value={MetaTileEntityPrimitiveWaterPump.class, MetaTileEntityPumpHatch.class, MetaTileEntityWorkbench.class, MetaTileEntityClipboard.class}, remap=false)
    private static abstract class WoodSoundMTEsMixin
    extends MTEsMixin {
        private WoodSoundMTEsMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return SoundType.WOOD;
        }
    }

    @Mixin(value={MetaTileEntityCokeOven.class, MetaTileEntityCokeOvenHatch.class, MetaTileEntityPrimitiveBlastFurnace.class}, remap=false)
    private static abstract class StoneSoundMTEsMixin
    extends MTEsMixin {
        private StoneSoundMTEsMixin() {
        }

        @Override
        @Unique
        @NotNull
        public SoundType getSoundType() {
            return SoundType.STONE;
        }
    }
}

