/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.mui2.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PlayerInventoryGuiData;
import com.cleanroommc.modularui.factory.inventory.InventoryType;
import com.cleanroommc.modularui.factory.inventory.InventoryTypes;
import com.cleanroommc.modularui.utils.Platform;
import dev.tianmi.sussypatches.api.core.mixin.extension.mui2.ItemUIFactoryExtension;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.util.Mods;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class MetaItemGuiFactory
extends AbstractUIFactory<PlayerInventoryGuiData> {
    public static final MetaItemGuiFactory INSTANCE = new MetaItemGuiFactory();

    private MetaItemGuiFactory() {
        super("gregtech:meta_item");
    }

    public static void open(EntityPlayer player, InventoryType type, int index) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(type);
        GuiManager.open((UIFactory)INSTANCE, (GuiData)new PlayerInventoryGuiData(player, type, index), (EntityPlayerMP)MetaItemGuiFactory.verifyServerSide((EntityPlayer)player));
    }

    public static void openFromPlayerInventory(EntityPlayer player, int index) {
        MetaItemGuiFactory.open(player, InventoryTypes.PLAYER, index);
    }

    public static void openFromHand(EntityPlayer player, EnumHand hand) {
        MetaItemGuiFactory.openFromPlayerInventory(player, hand == EnumHand.OFF_HAND ? 40 : player.field_71071_by.field_70461_c);
    }

    public static void openFromBaubles(EntityPlayer player, int index) {
        if (!Mods.Baubles.isModLoaded()) {
            throw new IllegalArgumentException("Can't open UI for baubles item when bauble is not loaded!");
        }
        MetaItemGuiFactory.open(player, InventoryTypes.BAUBLES, index);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openClient(InventoryType type, int index) {
        Objects.requireNonNull(type);
        GuiManager.openFromClient((UIFactory)INSTANCE, (GuiData)new PlayerInventoryGuiData((EntityPlayer)Platform.getClientPlayer(), type, index));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openFromPlayerInventoryClient(int index) {
        MetaItemGuiFactory.openClient(InventoryTypes.PLAYER, index);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openFromHandClient(EnumHand hand) {
        MetaItemGuiFactory.openFromPlayerInventoryClient(hand == EnumHand.OFF_HAND ? 40 : Platform.getClientPlayer().field_71071_by.field_70461_c);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openFromBaublesClient(EntityPlayer player, int index) {
        if (!Mods.Baubles.isModLoaded()) {
            throw new IllegalArgumentException("Can't open UI for baubles item when bauble is not loaded!");
        }
        MetaItemGuiFactory.openClient(InventoryTypes.BAUBLES, index);
    }

    @NotNull
    public IGuiHolder<PlayerInventoryGuiData> getGuiHolder(PlayerInventoryGuiData data) {
        ItemStack stack = data.getUsedItemStack();
        Item item = stack.func_77973_b();
        if (!(item instanceof MetaItem)) {
            throw new IllegalArgumentException("Found item is not a valid MetaItem!");
        }
        MetaItem metaItem = (MetaItem)item;
        MetaItem.MetaValueItem valueItem = metaItem.getItem(stack);
        if (valueItem == null || valueItem.getUIManager() == null) {
            throw new IllegalArgumentException("Found MetaItem is not a gui holder!");
        }
        return ItemUIFactoryExtension.cast(valueItem.getUIManager());
    }

    public void writeGuiData(PlayerInventoryGuiData guiData, PacketBuffer buffer) {
        guiData.getInventoryType().write(buffer);
        buffer.func_150787_b(guiData.getSlotIndex());
    }

    @NotNull
    public PlayerInventoryGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PlayerInventoryGuiData(player, InventoryType.read((PacketBuffer)buffer), buffer.func_150792_a());
    }
}

