/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.util;

import dev.tianmi.sussypatches.api.unification.material.info.SusIconTypes;
import dev.tianmi.sussypatches.integration.baubles.BaublesModule;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.Mods;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SusUtil {
    public static String getPrefix(Material material) {
        return material.getModid().equals("gregtech") ? "" : material.getModid() + ":";
    }

    public static NonNullList<ItemStack> addAll(NonNullList<ItemStack> items, IItemHandler handler, boolean recursive) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            IItemHandler stackHandler;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            items.add((Object)stack);
            if (!recursive || stack.func_190916_E() > 1 || (stackHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
            SusUtil.addAll(items, stackHandler, true);
        }
        return items;
    }

    public static NonNullList<ItemStack> gatherAllItems(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (Mods.Baubles.isModLoaded()) {
            playerInv = new ItemHandlerList(Arrays.asList(playerInv, BaublesModule.getBaublesInvWrapper(player)));
        }
        assert (playerInv != null);
        return SusUtil.addAll((NonNullList<ItemStack>)NonNullList.func_191196_a(), playerInv, true);
    }

    public static TextureAtlasSprite getBlockSprite(MaterialIconType iconType, Material material) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(iconType.getBlockTexturePath(material.getMaterialIconSet()).toString());
    }

    public static MaterialIconType getIconType(ItemPipeType itemPipeType) {
        MaterialIconType materialIconType;
        switch (itemPipeType) {
            case SMALL: 
            case RESTRICTIVE_SMALL: {
                materialIconType = SusIconTypes.pipeSmall;
                break;
            }
            case LARGE: 
            case RESTRICTIVE_LARGE: {
                materialIconType = SusIconTypes.pipeLarge;
                break;
            }
            case HUGE: 
            case RESTRICTIVE_HUGE: {
                materialIconType = SusIconTypes.pipeHuge;
                break;
            }
            default: {
                materialIconType = SusIconTypes.pipeNormal;
            }
        }
        return materialIconType;
    }

    public static MaterialIconType getIconType(FluidPipeType fluidPipeType) {
        MaterialIconType materialIconType;
        switch (fluidPipeType) {
            case TINY: {
                materialIconType = SusIconTypes.pipeTiny;
                break;
            }
            case SMALL: {
                materialIconType = SusIconTypes.pipeSmall;
                break;
            }
            case LARGE: {
                materialIconType = SusIconTypes.pipeLarge;
                break;
            }
            case HUGE: {
                materialIconType = SusIconTypes.pipeHuge;
                break;
            }
            case QUADRUPLE: {
                materialIconType = SusIconTypes.pipeQuadruple;
                break;
            }
            case NONUPLE: {
                materialIconType = SusIconTypes.pipeNonuple;
                break;
            }
            default: {
                materialIconType = SusIconTypes.pipeNormal;
            }
        }
        return materialIconType;
    }

    public static MaterialIconType getIconType(Insulation insulation) {
        MaterialIconType materialIconType;
        switch (insulation) {
            case CABLE_SINGLE: {
                materialIconType = SusIconTypes.insulationSingle;
                break;
            }
            case CABLE_DOUBLE: {
                materialIconType = SusIconTypes.insulationDouble;
                break;
            }
            case CABLE_QUADRUPLE: {
                materialIconType = SusIconTypes.insulationQuadruple;
                break;
            }
            case CABLE_OCTAL: {
                materialIconType = SusIconTypes.insulationOctal;
                break;
            }
            case CABLE_HEX: {
                materialIconType = SusIconTypes.insulationHex;
                break;
            }
            default: {
                materialIconType = SusIconTypes.insulationSide;
            }
        }
        return materialIconType;
    }
}

