/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import dev.tianmi.sussypatches.api.event.RenderItemOverlayEvent;
import dev.tianmi.sussypatches.common.SusConfig;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.ToolChargeBarRenderer;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeTank;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidBarRenderer {
    private static final Map<String, Set<Integer>> BLACKLIST = new Object2ObjectOpenHashMap();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderItemOverlayEvent(RenderItemOverlayEvent event) {
        event.enqueue((stack, x, y, text) -> {
            IFluidHandlerItem handler;
            ResourceLocation rl = stack.func_77973_b().getRegistryName();
            if (rl == null) {
                return;
            }
            if (BLACKLIST.containsKey(rl.toString()) && BLACKLIST.get(rl.toString()).contains(stack.func_77960_j())) {
                return;
            }
            ItemStack newStack = stack.func_77946_l();
            if (newStack.func_190916_E() > 1) {
                newStack.func_190920_e(1);
            }
            if ((handler = FluidUtil.getFluidHandler((ItemStack)newStack)) == null) {
                return;
            }
            IFluidTankProperties[] props = handler.getTankProperties();
            if (props.length != 1) {
                return;
            }
            FluidStack fluid = props[0].getContents();
            if (fluid == null) {
                return;
            }
            int capacity = props[0].getCapacity();
            if (capacity <= 0) {
                MetaTileEntity mte = GTUtility.getMetaTileEntity((ItemStack)stack);
                if (mte instanceof MetaTileEntityCreativeTank) {
                    capacity = fluid.amount;
                } else {
                    return;
                }
            }
            double level = MathHelper.func_151237_a((double)((double)fluid.amount / (double)capacity), (double)0.0, (double)1.0);
            Color color = new Color(GTUtility.convertRGBtoOpaqueRGBA_MC((int)RenderUtil.getFluidColor((FluidStack)fluid)));
            ToolChargeBarRenderer.render((double)level, (int)x, (int)y, (int)0, (boolean)true, (Color)color.darker(), (Color)color.brighter(), (boolean)false);
        });
    }

    static {
        for (String item : SusConfig.FEAT.fluidBarBlacklist) {
            String[] parts = item.split("@");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Entries in fluid bar blacklist must be a registry name, then metadata, seperated by '@'!");
            }
            int meta = Integer.parseInt(parts[1]);
            BLACKLIST.computeIfAbsent(parts[0], k -> new ObjectOpenHashSet()).add(meta);
        }
    }
}

