/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import dev.tianmi.sussypatches.api.core.mixin.extension.SpecialModelExtension;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.common.items.MetaItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisibleFluidCell {
    private static final int PIXEL_VAIL = 11;
    private static final int PIXEL_CELL = 10;
    private static final int PIXEL_CELL_LARGE = 14;

    public static void changeModelAmount(MetaItem.MetaValueItem fluidCell, int pixel) {
        SpecialModelExtension.cast(fluidCell.setModelAmount((pixel - 1) * 2 + 1)).setModelDispatcher(itemStack -> {
            IFluidHandlerItem handler;
            ItemStack singleStack = itemStack.func_77946_l();
            if (singleStack.func_190916_E() > 1) {
                singleStack.func_190920_e(1);
            }
            if ((handler = FluidUtil.getFluidHandler((ItemStack)singleStack)) == null) {
                return pixel;
            }
            IFluidTankProperties[] tankProps = handler.getTankProperties();
            if (tankProps.length != 1) {
                return pixel;
            }
            IFluidTankProperties tankProp = tankProps[0];
            FluidStack fluidStack = tankProp.getContents();
            if (fluidStack == null) {
                return pixel;
            }
            boolean isGas = fluidStack.getFluid().isGaseous();
            int amount = fluidStack.amount;
            int capacity = tankProp.getCapacity();
            return isGas ? 2 * pixel - 2 - (pixel - 1) * amount / capacity : (pixel - 1) * amount / capacity + 1;
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemRegistration(RegistryEvent.Register<Item> event) {
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_GLASS_VIAL, 11);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_UNIVERSAL, 10);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_LARGE_STEEL, 14);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_LARGE_ALUMINIUM, 14);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_LARGE_STAINLESS_STEEL, 14);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_LARGE_TITANIUM, 14);
        VisibleFluidCell.changeModelAmount(MetaItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL, 14);
    }
}

