/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.shadow.it.unimi.dsi.util;

import dev.tianmi.sussypatches.shadow.it.unimi.dsi.Util;
import dev.tianmi.sussypatches.shadow.it.unimi.dsi.util.SplitMix64Random;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class XoShiRo256PlusPlusRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long s0;
    private long s1;
    private long s2;
    private long s3;
    private static final long[] JUMP = new long[]{1733541517147835066L, -3051731464161248980L, -6244198995065845334L, 4155657270789760540L};
    private static final long[] LONG_JUMP = new long[]{8566230491382795199L, -4251311993797857357L, 8606660816089834049L, 4111957640723818037L};

    protected XoShiRo256PlusPlusRandom(long s0, long s1, long s2, long s3) {
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s3;
    }

    public XoShiRo256PlusPlusRandom() {
        this(Util.randomSeed());
    }

    public XoShiRo256PlusPlusRandom(long seed) {
        this.setSeed(seed);
    }

    @NotNull
    public XoShiRo256PlusPlusRandom copy() {
        return new XoShiRo256PlusPlusRandom(this.s0, this.s1, this.s2, this.s3);
    }

    @Override
    public long nextLong() {
        long t0 = this.s0;
        long result = Long.rotateLeft(t0 + this.s3, 23) + t0;
        long t = this.s1 << 17;
        this.s2 ^= t0;
        this.s3 ^= this.s1;
        this.s1 ^= this.s2;
        this.s0 ^= this.s3;
        this.s2 ^= t;
        this.s3 = Long.rotateLeft(this.s3, 45);
        return result;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextDoubleFast() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public void nextBytes(byte @NotNull [] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    protected XoShiRo256PlusPlusRandom jump(long[] jump) {
        long s0 = 0L;
        long s1 = 0L;
        long s2 = 0L;
        long s3 = 0L;
        for (long element : jump) {
            for (int b = 0; b < 64; ++b) {
                if ((element & 1L << b) != 0L) {
                    s0 ^= this.s0;
                    s1 ^= this.s1;
                    s2 ^= this.s2;
                    s3 ^= this.s3;
                }
                this.nextLong();
            }
        }
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s3;
        return this;
    }

    @NotNull
    public XoShiRo256PlusPlusRandom jump() {
        return this.jump(JUMP);
    }

    @NotNull
    public XoShiRo256PlusPlusRandom longJump() {
        return this.jump(LONG_JUMP);
    }

    @NotNull
    public XoShiRo256PlusPlusRandom split() {
        this.nextLong();
        XoShiRo256PlusPlusRandom split = this.copy();
        long h0 = split.s0;
        long h1 = split.s1;
        long h2 = split.s2;
        long h3 = split.s3;
        h2 = Long.rotateLeft(h2, 50);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 30);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 41);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 54);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 48);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 38);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 37);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 62);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 5);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 36);
        split.s0 = h0;
        split.s1 = h1;
        split.s2 = h2;
        split.s3 = h3 ^= (h1 += h2);
        return split;
    }

    @Override
    public void setSeed(long seed) {
        SplitMix64Random r = new SplitMix64Random(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
        this.s2 = r.nextLong();
        this.s3 = r.nextLong();
    }

    public void setState(long @NotNull [] state) {
        if (state.length != 4) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 4);
        }
        this.s0 = state[0];
        this.s1 = state[1];
        this.s2 = state[2];
        this.s3 = state[3];
    }

    public void setState(long state0, long state1, long state2, long state3) {
        this.s0 = state0;
        this.s1 = state1;
        this.s2 = state2;
        this.s3 = state3;
    }
}

