/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common.helper;

import dev.tianmi.sussypatches.api.event.RenderItemOverlayEvent;
import dev.tianmi.sussypatches.core.mixin.feature.fluidcontainerbar.DrumAccessor;
import dev.tianmi.sussypatches.core.mixin.feature.fluidcontainerbar.QuantumTankAccessor;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.ToolChargeBarRenderer;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeTank;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidBarRenderer {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderItemOverlayEvent(RenderItemOverlayEvent event) {
        event.enqueue((stack, x, y, text) -> {
            int capacity;
            if (stack.getCount() > 1) {
                return;
            }
            MetaTileEntity mte = GTUtility.getMetaTileEntity((ItemStack)stack);
            if (mte instanceof DrumAccessor) {
                DrumAccessor drum = (DrumAccessor)mte;
                capacity = drum.getTankSize();
            } else if (mte instanceof MetaTileEntityCreativeTank) {
                capacity = 1000;
            } else if (mte instanceof QuantumTankAccessor) {
                QuantumTankAccessor tank = (QuantumTankAccessor)mte;
                capacity = tank.getMaxFluidCapacity();
            } else {
                return;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid == null || fluid.amount <= 0) {
                return;
            }
            double level = (double)fluid.amount / (double)capacity;
            Color color = new Color(GTUtility.convertRGBtoOpaqueRGBA_MC((int)RenderUtil.getFluidColor((FluidStack)fluid)));
            ToolChargeBarRenderer.render((double)level, (int)x, (int)y, (int)0, (boolean)true, (Color)color.darker(), (Color)color.brighter(), (boolean)false);
        });
    }
}

