/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core;

import dev.tianmi.sussypatches.api.util.BoolSupplier;
import dev.tianmi.sussypatches.api.util.SusMods;
import dev.tianmi.sussypatches.common.SusConfig;
import gregtech.api.util.Mods;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LateMixinLoader
implements ILateMixinLoader {
    private static final String ROOT = "sussypatches/";
    private static final String MIXINS = "mixins.";
    private static final String JSON = ".json";
    private static final Map<String, BoolSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BoolSupplier>();

    private static void add(Type type, String name, BoolSupplier ... conditions) {
        BoolSupplier supplier = BoolSupplier.TRUE;
        for (BoolSupplier condition : conditions) {
            supplier = supplier.and(condition);
        }
        MIXIN_CONFIGS.put(ROOT + (Object)((Object)type) + MIXINS + name + JSON, supplier);
    }

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        return MIXIN_CONFIGS.get(mixinConfig).get();
    }

    static {
        LateMixinLoader.add(Type.FEATURE, "connectedtextures", SusMods.of(Mods.CTM), () -> SusConfig.FEAT.CTM);
        LateMixinLoader.add(Type.COMPAT, "loliasm.ondemandanimation", SusMods.LoliASM, () -> SusConfig.COMPAT.ON_DEMAND);
        LateMixinLoader.add(Type.COMPAT, "alfheim.dummyworldcrash", SusMods.of(Mods.Alfheim));
        LateMixinLoader.add(Type.COMPAT, "vintagefix.lampbakedmodel", SusMods.VintageFix);
    }

    private static enum Type {
        FEATURE,
        BUGFIX,
        TWEAK,
        COMPAT;


        public String toString() {
            return this.name().toLowerCase() + "/";
        }
    }
}

