/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.common;

import com.cleanroommc.configanytime.ConfigAnytime;
import dev.tianmi.sussypatches.SussyPatches;
import dev.tianmi.sussypatches.api.util.SusMods;
import net.minecraftforge.common.config.Config;

@Config(modid="sussypatches")
public class SusConfig {
    @Config.Comment(value={"Config options for additional features"})
    @Config.Name(value="Features")
    public static final Feature FEAT = new Feature();
    @Config.Comment(value={"Config options for external mod compat"})
    @Config.Name(value="Compatibilities")
    public static final Compat COMPAT = new Compat();
    @Config.Comment(value={"Config options for fixing... bugs"})
    @Config.Name(value="Bugfixes")
    public static final Bugfix BUGFIX = new Bugfix();
    @Config.Comment(value={"Config options for tweaking existing features"})
    @Config.Name(value="Tweaks")
    public static final Tweaks TWEAKS = new Tweaks();

    static {
        if (SusMods.ConfigAnytime.isLoaded()) {
            ConfigAnytime.register(SusConfig.class);
        } else if (!SusMods.Lwjgl3ify.isLoaded()) {
            SussyPatches.LOGGER.error("ConfigAnytime not found! Config options may not work.");
        }
    }

    public static final class Feature {
        @Config.Comment(value={"Make ConnectedTexturesMod (CTM) work on GregTech multiblocks.", "Needs CTM to be loaded.", "Default: true"})
        @Config.Name(value="Connected textures for multiblocks")
        @Config.RequiresMcRestart
        public boolean multiCTM = true;
    }

    public static final class Compat {
        @Config.Comment(value={"Fixes GregTech machines lost their animations when \"On-Demand Animations\" is turned on in CensoredASM.", "Default: true"})
        @Config.Name(value="Fix on-demand animations")
        @Config.RequiresMcRestart
        public boolean fixOnDemand = true;
        @Config.Comment(value={"Fixes GregTech's DummyWorld crashs with Alfheim v1.6+, which causes all GT recipes to disappear in JEI.", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Fix Alfheim v1.6+ breaking JEI")
        @Config.RequiresMcRestart
        public boolean fixDummyWorld = true;
        @Config.Comment(value={"Fixes some GT lamps losing their inventory models when both VintageFix and ConnectedTexturesMod are loaded.", "Default: true"})
        @Config.Name(value="Fix VintageFix making lamps invisible")
        @Config.RequiresMcRestart
        public boolean fixLampModel = true;
        @Config.Comment(value={"Fixes Fluidlogged API v2 making multiblocks with fluid blocks in the structure failed to render the in-world preview.", "Fixed in Fluidlogged API v3.", "Default: true"})
        @Config.Name(value="Fix Fluidlogged API v2 render failure")
        @Config.RequiresMcRestart
        public boolean fixInworldPreview = true;
        @Config.Comment(value={"Fixes various GrS issues, including:", " - GrS not respecting the item namespace.", " - Fluid amount multiplier duplicates in the copied recipe removal code.", "Could also fix some CrT issues, but I didn't brother testing.", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Fix various GrS issues")
        @Config.RequiresMcRestart
        public boolean fixGrS = true;
    }

    public static final class Bugfix {
        @Config.Comment(value={"Fixes clipboards always rendered at full brightness.", "Default: true"})
        @Config.Name(value="Fix clipboards lighting")
        @Config.RequiresMcRestart
        public boolean clipboardLighting = true;
        @Config.Comment(value={"Fixes facades have weird lighting.", "A.k.a. different from normal blocks.", "Default: true"})
        @Config.Name(value="Fix facades lighting")
        @Config.RequiresMcRestart
        public boolean facadeLighting = true;
        @Config.Comment(value={"Implements getItem method for BlockMachine.", "Fixes mod fail to render GT TileEntities, e.g. XNet.", "Note: for RFTools you will need ReFinedTools.", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Implement getItem for BlockMachine")
        @Config.RequiresMcRestart
        public boolean implGetItem = true;
        @Config.Comment(value={"Fixes MTE Packet Data Memory Leak", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Fix packet data memory leak")
        @Config.RequiresMcRestart
        public boolean packetMemLeak = true;
        @Config.Comment(value={"Reverses the data transfer direction correctly.", "Fixes pipes losing data when adding/removing covers.", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Fix data transfer between pipes")
        @Config.RequiresMcRestart
        public boolean pipeDataTransfer = true;
        @Config.Comment(value={"Refuses insertion into pipenets w/o specific facing.", "Fixes crashes with mods like RFTools.", "Default: true"})
        @Config.Name(value="Fix data transfer between pipes")
        @Config.RequiresMcRestart
        public boolean pipeInvCrash = true;
        @Config.Comment(value={"Don't let GTCEu register pipes for empty registrations.", "Fixes crashes for mods like BetterQuesting.", "Fixed in CEu master branch.", "Default: true"})
        @Config.Name(value="Stop invalid pipe registration")
        @Config.RequiresMcRestart
        public boolean invalidRegistration = true;
    }

    public static final class Tweaks {
        @Config.Comment(value={"Removes the annoying search bars from GT Creative Tabs", "Default: true"})
        @Config.Name(value="Remove search bars from GT tabs")
        @Config.RequiresMcRestart
        public boolean noSearchBars = true;
    }
}

