/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core;

import dev.tianmi.sussypatches.api.util.BoolSupplier;
import dev.tianmi.sussypatches.api.util.SusMods;
import dev.tianmi.sussypatches.common.SusConfig;
import gregtech.api.util.Mods;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LateMixinLoader
implements ILateMixinLoader {
    private static final String ROOT = "sussypatches/";
    private static final String MIXINS = "mixins.";
    private static final String JSON = ".json";
    private static final Map<String, BoolSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BoolSupplier>();

    private static void add(Type type, String name, Object ... conditions) {
        BoolSupplier supplier = BoolSupplier.TRUE;
        for (Object condition : conditions) {
            if (condition instanceof BoolSupplier) {
                BoolSupplier boolSupplier = (BoolSupplier)condition;
                supplier = supplier.and(boolSupplier);
                continue;
            }
            if (condition instanceof Boolean) {
                Boolean bool = (Boolean)condition;
                supplier = supplier.and(() -> bool);
                continue;
            }
            throw new IllegalArgumentException("Invalid condition type: " + condition.getClass());
        }
        MIXIN_CONFIGS.put(ROOT + (Object)((Object)type) + MIXINS + name + JSON, supplier);
    }

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        return MIXIN_CONFIGS.get(mixinConfig).get();
    }

    static {
        LateMixinLoader.add(Type.FEATURE, "connectedtextures", SusMods.of(Mods.CTM), SusConfig.FEAT.multiCTM);
        LateMixinLoader.add(Type.COMPAT, "ondemandanimation", SusMods.LoliASM, SusConfig.COMPAT.fixOnDemand);
        LateMixinLoader.add(Type.COMPAT, "dummyworldcrash", SusMods.of(Mods.Alfheim), SusConfig.COMPAT.fixDummyWorld);
        LateMixinLoader.add(Type.COMPAT, "lampbakedmodel", SusMods.VintageFix, SusConfig.COMPAT.fixLampModel);
        LateMixinLoader.add(Type.COMPAT, "inworldpreviewcrash", SusMods.FluidloggedAPI_2, SusConfig.COMPAT.fixInworldPreview);
        LateMixinLoader.add(Type.COMPAT, "variousgrsissue", SusMods.of(Mods.GroovyScript).or(SusMods.of(Mods.CraftTweaker)), SusConfig.COMPAT.fixGrS);
        LateMixinLoader.add(Type.BUGFIX, "clipboardlighting", SusConfig.BUGFIX.clipboardLighting);
        LateMixinLoader.add(Type.BUGFIX, "facadelighting", SusConfig.BUGFIX.facadeLighting);
        LateMixinLoader.add(Type.BUGFIX, "implgetitem", SusConfig.BUGFIX.implGetItem);
        LateMixinLoader.add(Type.BUGFIX, "packetdatamemleak", SusConfig.BUGFIX.packetMemLeak);
        LateMixinLoader.add(Type.BUGFIX, "pipedatatransfer", SusConfig.BUGFIX.pipeDataTransfer);
        LateMixinLoader.add(Type.BUGFIX, "pipeinvcrash", SusConfig.BUGFIX.pipeInvCrash);
        LateMixinLoader.add(Type.BUGFIX, "invalidregistration", SusConfig.BUGFIX.invalidRegistration);
        LateMixinLoader.add(Type.TWEAK, "tabnosearchbars", SusConfig.TWEAKS.noSearchBars);
    }

    static enum Type {
        FEATURE,
        BUGFIX,
        TWEAK,
        COMPAT;


        public String toString() {
            return this.name().toLowerCase() + "/";
        }
    }
}

