/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core.asm;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.tianmi.sussypatches.api.core.asm.IExplicitTransformer;
import dev.tianmi.sussypatches.core.asm.transformer.BlockPatternTransformer;
import dev.tianmi.sussypatches.core.asm.transformer.IGTToolTransformer;
import dev.tianmi.sussypatches.core.asm.transformer.MBPRTransformer;
import org.objectweb.asm.tree.ClassNode;

public class SusTransformers {
    private static final Multimap<String, IExplicitTransformer> TRANSFORMERS = MultimapBuilder.hashKeys().arrayListValues().build();

    public static void transform(String targetClassName, ClassNode targetClass) {
        TRANSFORMERS.get((Object)targetClassName).forEach(transformer -> transformer.transform(targetClass));
    }

    private static void add(IExplicitTransformer transformer) {
        TRANSFORMERS.put((Object)transformer.targetClassName(), (Object)transformer);
    }

    static {
        SusTransformers.add(new MBPRTransformer());
        SusTransformers.add(new IGTToolTransformer());
        SusTransformers.add(new BlockPatternTransformer());
    }
}

