/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.api.util;

import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface BoolSupplier
extends BooleanSupplier {
    public static final BoolSupplier TRUE = () -> true;
    public static final BoolSupplier FALSE = () -> false;

    public boolean get();

    @Override
    default public boolean getAsBoolean() {
        return this.get();
    }

    public static BoolSupplier of(BooleanSupplier supplier) {
        return supplier::getAsBoolean;
    }

    public static BoolSupplier of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    default public BoolSupplier and(BoolSupplier other) {
        return () -> this.get() && other.get();
    }

    default public BoolSupplier or(BoolSupplier other) {
        return () -> this.get() || other.get();
    }

    default public BoolSupplier xor(BoolSupplier other) {
        return () -> this.get() ^ other.get();
    }

    default public BoolSupplier negate() {
        return () -> !this.get();
    }

    public static BoolSupplier compact(Object ... conditions) {
        BoolSupplier supplier = TRUE;
        for (Object condition : conditions) {
            if (condition instanceof BoolSupplier) {
                BoolSupplier boolSupplier = (BoolSupplier)condition;
                supplier = supplier.and(boolSupplier);
                continue;
            }
            if (condition instanceof Boolean) {
                Boolean bool = (Boolean)condition;
                supplier = supplier.and(BoolSupplier.of(bool));
                continue;
            }
            if (condition instanceof BooleanSupplier) {
                BooleanSupplier booleanSupplier = (BooleanSupplier)condition;
                supplier = supplier.and(BoolSupplier.of(booleanSupplier));
                continue;
            }
            throw new IllegalArgumentException("Invalid condition type: " + condition.getClass());
        }
        return supplier;
    }
}

