/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.core.mixin.feature.coverretainexact;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import dev.tianmi.sussypatches.api.core.mixin.extension.TransferModeExtension;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.filter.FluidFilterContainer;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CoverFluidRegulator.class}, remap=false)
public abstract class FluidRegulatorMixin
extends CoverPump {
    @Shadow
    protected TransferMode transferMode;
    @Shadow
    protected int transferAmount;

    FluidRegulatorMixin() {
        super(null, null, null, 0, 0);
    }

    @Shadow
    protected abstract int doKeepExact(int var1, IFluidHandler var2, IFluidHandler var3, Predicate<FluidStack> var4, int var5);

    @Shadow
    protected abstract void setTransferAmount(int var1);

    @Inject(method={"doTransferFluidsInternal"}, at={@At(value="FIELD", target="Lgregtech/common/covers/CoverFluidRegulator$1;$SwitchMap$gregtech$common$covers$TransferMode:[I", opcode=178)}, cancellable=true)
    private void retainExactGuard(IFluidHandler ignored, IFluidHandler alsoIgnored, int transferLimit, CallbackInfoReturnable<Integer> cir, @Local(name={"sourceHandler"}) IFluidHandler sourceHandler, @Local(name={"destHandler"}) IFluidHandler destHandler) {
        if (this.transferMode == TransferModeExtension.RETAIN_EXACT) {
            cir.setReturnValue((Object)this.doKeepExact(transferLimit, sourceHandler, destHandler, arg_0 -> ((FluidFilterContainer)this.fluidFilter).testFluidStack(arg_0), this.transferAmount));
        }
    }

    @ModifyExpressionValue(method={"doKeepExact"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="keepAmount", local={@Local(type=int.class, name={"keepAmount"})})
    @Expression(value={"? < keepAmount"})
    private boolean retainExactCheck(boolean original, @Local(name={"keepAmount"}) int keepAmount, @Local(name={"amountInDest"}) LocalIntRef amountInDestRef, @Local(name={"sourceFluids"}) Map<FluidStack, Integer> sourceFluids, @Local(name={"fluidStack"}) FluidStack fluidStack) {
        if (this.transferMode == TransferModeExtension.RETAIN_EXACT) {
            int amountInDest = sourceFluids.getOrDefault(fluidStack, 0);
            amountInDestRef.set(amountInDest);
            return amountInDest > keepAmount;
        }
        return original;
    }

    @ModifyArg(method={"doKeepExact"}, at=@At(value="INVOKE", target="Ljava/lang/Math;min(II)I", ordinal=0), index=1)
    private int retainExactMin(int original) {
        return this.transferMode == TransferModeExtension.RETAIN_EXACT ? -original : original;
    }

    @Inject(method={"adjustTransferSize"}, at={@At(value="FIELD", target="Lgregtech/common/covers/CoverFluidRegulator$1;$SwitchMap$gregtech$common$covers$TransferMode:[I", opcode=178)}, cancellable=true)
    private void retainExactGuard(int amount, CallbackInfo ci) {
        if (this.transferMode == TransferModeExtension.RETAIN_EXACT) {
            this.setTransferAmount(MathHelper.func_76125_a((int)(this.transferAmount + amount), (int)0, (int)Integer.MAX_VALUE));
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"shouldDisplayAmountSlider"}, at={@At(value="TAIL")})
    private boolean retainExactAmountSlider(boolean original) {
        return original || this.transferMode == TransferModeExtension.RETAIN_EXACT;
    }
}

