/*
 * Decompiled with CFR 0.152.
 */
package dev.tianmi.sussypatches.client.renderer.scene;

import dev.tianmi.sussypatches.api.core.mixin.extension.WSRExtension;
import dev.tianmi.sussypatches.api.util.OptiFineHelper;
import dev.tianmi.sussypatches.api.util.RenderPass;
import dev.tianmi.sussypatches.api.util.SusMods;
import dev.tianmi.sussypatches.client.renderer.buffer.VertexArrayObject;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.scene.ISceneRenderHook;
import gregtech.client.renderer.scene.ImmediateWorldSceneRenderer;
import gregtech.client.renderer.scene.WorldSceneRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.ShadersRender;

@SideOnly(value=Side.CLIENT)
public class VBOWorldSceneRenderer
extends ImmediateWorldSceneRenderer {
    protected static final VertexArrayObject[] VAOS = new VertexArrayObject[BlockRenderLayer.values().length];
    protected static final VertexBuffer[] VBOS = new VertexBuffer[BlockRenderLayer.values().length];
    protected static final Map<BlockPos, TileEntity> TILE_ENTITIES = new Object2ObjectArrayMap();
    protected boolean isDirty = true;

    public VBOWorldSceneRenderer(World world) {
        super(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadVBO() {
        Minecraft mc = Minecraft.getMinecraft();
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
                VBOWorldSceneRenderer.setDefaultPassRenderState((int)pass);
                OptiFineHelper.preRenderChunkLayer(layer);
                BufferBuilder buffer = Tessellator.getInstance().getBuffer();
                buffer.begin(7, DefaultVertexFormats.BLOCK);
                BlockRendererDispatcher brd = mc.getBlockRendererDispatcher();
                Collection<BlockPos> renderedBlocks = WSRExtension.cast((WorldSceneRenderer)this).sus$getRenderedBlocks();
                for (BlockPos pos : renderedBlocks) {
                    IBlockState state = this.world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (block == Blocks.AIR || !block.canRenderInLayer(state = state.getActualState((IBlockAccess)this.world, pos), layer)) continue;
                    brd.renderBlock(state, pos, (IBlockAccess)this.world, buffer);
                }
                buffer.finishDrawing();
                buffer.reset();
                int i = layer.ordinal();
                VertexBuffer vbo = VBOS[i];
                if (vbo == null) {
                    vbo = VBOWorldSceneRenderer.VBOS[i] = new VertexBuffer(DefaultVertexFormats.BLOCK);
                }
                vbo.bufferData(buffer.getByteBuffer());
                if (SusMods.OpenGL3.isLoaded()) {
                    VertexArrayObject vao = VAOS[i];
                    if (vao == null) {
                        vao = VBOWorldSceneRenderer.VAOS[i] = new VertexArrayObject();
                    }
                    vao.bindVertexArray();
                    vbo.bindBuffer();
                    this.enableClientStates();
                    this.setupArrayPointers();
                    vao.unbindVertexArray();
                    this.disableClientStates();
                    vbo.unbindBuffer();
                }
                OptiFineHelper.postRenderChunkLayer(layer);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        this.isDirty = false;
    }

    protected void drawWorld() {
        if (this.isDirty) {
            this.uploadVBO();
        }
        Minecraft mc = Minecraft.getMinecraft();
        GlStateManager.enableCull();
        GlStateManager.enableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        mc.entityRenderer.disableLightmap();
        mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        GlStateManager.disableLighting();
        GlStateManager.enableTexture2D();
        GlStateManager.enableAlpha();
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            RenderPass pass = layer == BlockRenderLayer.TRANSLUCENT ? RenderPass.TRANSLUCENT : RenderPass.NORMAL;
            VBOWorldSceneRenderer.setPassRenderState(pass);
            OptiFineHelper.preRenderChunkLayer(layer);
            GlStateManager.pushMatrix();
            int i = layer.ordinal();
            VertexBuffer vbo = VBOS[i];
            int preVBO = GlStateManager.glGetInteger((int)34964);
            vbo.bindBuffer();
            if (SusMods.OpenGL3.isLoaded()) {
                VertexArrayObject vao = VAOS[i];
                vao.bindVertexArray();
                vbo.drawArrays(7);
                vao.unbindVertexArray();
            } else {
                this.enableClientStates();
                this.setupArrayPointers();
                vbo.drawArrays(7);
                this.disableClientStates();
            }
            vbo.unbindBuffer();
            OpenGlHelper.glBindBuffer((int)OpenGlHelper.GL_ARRAY_BUFFER, (int)preVBO);
            GlStateManager.popMatrix();
            OptiFineHelper.postRenderChunkLayer(layer);
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        this.renderTileEntities();
        GlStateManager.shadeModel((int)7425);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPos> blocks, ISceneRenderHook _null) {
        this.isDirty = true;
        super.addRenderedBlocks(blocks, _null);
        TILE_ENTITIES.clear();
        blocks.forEach(pos -> {
            IGregTechTileEntity gtte;
            TileEntity tile = this.world.getTileEntity(pos);
            if (tile != null && (!(tile instanceof IGregTechTileEntity) || (gtte = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof IFastRenderMetaTileEntity)) {
                TILE_ENTITIES.put((BlockPos)pos, tile);
            }
        });
        return this;
    }

    protected void enableClientStates() {
        GlStateManager.glEnableClientState((int)32884);
        OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.defaultTexUnit);
        GlStateManager.glEnableClientState((int)32888);
        OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.lightmapTexUnit);
        GlStateManager.glEnableClientState((int)32888);
        OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.defaultTexUnit);
        GlStateManager.glEnableClientState((int)32886);
    }

    protected void disableClientStates() {
        for (VertexFormatElement element : DefaultVertexFormats.BLOCK.getElements()) {
            switch (element.getUsage()) {
                case POSITION: {
                    GlStateManager.glDisableClientState((int)32884);
                    break;
                }
                case COLOR: {
                    GlStateManager.glDisableClientState((int)32886);
                    break;
                }
                case UV: {
                    OpenGlHelper.setClientActiveTexture((int)(OpenGlHelper.defaultTexUnit + element.getIndex()));
                    GlStateManager.glDisableClientState((int)32888);
                    OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.defaultTexUnit);
                    break;
                }
            }
        }
    }

    protected void setupArrayPointers() {
        if (SusMods.ShadersMod.isLoaded()) {
            ShadersRender.setupArrayPointersVbo();
        } else {
            GlStateManager.glVertexPointer((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.glColorPointer((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.glTexCoordPointer((int)2, (int)5126, (int)28, (int)16);
            OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.lightmapTexUnit);
            GlStateManager.glTexCoordPointer((int)2, (int)5122, (int)28, (int)24);
            OpenGlHelper.setClientActiveTexture((int)OpenGlHelper.defaultTexUnit);
        }
    }

    protected void renderTileEntities() {
        RenderHelper.enableStandardItemLighting();
        TileEntityRendererDispatcher terd = TileEntityRendererDispatcher.instance;
        for (RenderPass pass : RenderPass.values()) {
            ForgeHooksClient.setRenderPass((int)pass.ordinal());
            VBOWorldSceneRenderer.setPassRenderState(pass);
            TILE_ENTITIES.forEach((pos, tile) -> {
                if (tile.shouldRenderInPass(pass.ordinal())) {
                    terd.render(tile, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0f);
                }
            });
        }
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.disableStandardItemLighting();
    }

    public static void setPassRenderState(RenderPass pass) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass.isTranslucent()) {
            GlStateManager.disableBlend();
            GlStateManager.enableCull();
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableBlend();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.enableDepth();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.shadeModel((int)7424);
        }
    }
}

